package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.goblin.dto.vo.GoblinStoreGoodsCategoryVo;

import java.util.List;

public interface IGoblinStoreMgtCategoryService {
    /**
     * 店铺商品分类:列表
     *
     * @param storeId 店铺ID
     * @return List<GoblinStoreGoodsCategoryVo>
     */
    List<GoblinStoreGoodsCategoryVo> list(String storeId);

    /**
     * 店铺商品分类:添加
     *
     * @param uid                   UID
     * @param storeGoodsCategoryVos List<GoblinStoreGoodsCategoryVo>
     * @return boolean
     */
    boolean add(String uid, List<GoblinStoreGoodsCategoryVo> storeGoodsCategoryVos);

    /**
     * 店铺商品分类:编辑
     *
     * @param uid                  UID
     * @param storeGoodsCategoryVo GoblinStoreGoodsCategoryVo
     * @return boolean
     */
    boolean edit(String uid, GoblinStoreGoodsCategoryVo storeGoodsCategoryVo);

    /**
     * 店铺商品分类:删除
     *
     * @param uid     UID
     * @param storeId 店铺ID
     * @param cateid  店铺分类ID
     * @return boolean
     */
    boolean del(String uid, String storeId, String cateid);
}
