package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 热词

 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinFrontHotWord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 热词
     */
    private String word;

    /**
     * 1开启2未开启
     */
    private Integer status;

    /**
     * 排序
     */
    private Integer indexs;

    /**
     * 1、滚动2、按时切换
     */
    private Integer changeType;

    /**
     * 切换时间单位为s
     */
    private Integer changeTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;

    /**
     * 热词id
     */
    private String hotWordId;

    /**
     * 0未删除1已删除
     */
    private Integer delTag;


}
