package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 * NFT下单所需商品相关参数
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-03-24
 */
@ApiModel(value = "GoblinNftOrderPayGoodsParam", description = "下单所需商品相关参数")
@Data
public class GoblinNftOrderPayGoodsParam {

    @ApiModelProperty(position = 10, required = true, value = "商铺id")
    @NotBlank(message = "storeId不能为空")
    private String storeId;

    @ApiModelProperty(position = 11, required = true, value = "spuId")
    @NotBlank(message = "spuId不能为空")
    private String spuId;

    @ApiModelProperty(position = 12, required = true, value = "skuId")
    @NotBlank(message = "skuId不能为空")
    private String skuId;

    @ApiModelProperty(position = 13, value = "平台券码")
    private String platVoucherCode;

    @ApiModelProperty(position = 14, value = "商品券码")
    private String storeVoucherCode;
}
