package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.goblin.entity.GoblinNftOrderRefund;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * NFT订单退单退款表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-03-24
 */
@ApiModel(value = "GoblinNftOrderCallBackVo", description = "退款订单vo")
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftOrderCallBackVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单退单表id")
    private String orderRefundId;

    @ApiModelProperty(value = "退款单号")
    private String refundCode;

    @ApiModelProperty(value = "订单id")
    private String orderId;

    @ApiModelProperty(value = "订单编号")
    private String orderCode;

    @ApiModelProperty(value = "商铺id")
    private String storeId;

    @ApiModelProperty(value = "用户id")
    private String userId;

    @ApiModelProperty(value = "skuIdNums")
    private String skuIdNums;

    @ApiModelProperty(value = "退货时候实际退款金额")
    private BigDecimal realBackPrice;

    @ApiModelProperty(value = "退款状态 1申请|2退款成功|3退款失败")
    private Integer status;

    @ApiModelProperty(value = "退款时间")
    private LocalDateTime refundAt;

    @ApiModelProperty(value = "退款失败原因")
    private String errorReason;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updatedAt;

    public GoblinNftOrderCallBackVo copy(GoblinNftOrderRefund source) {
        this.setOrderRefundId(source.getOrderRefundId());
        this.setRefundCode(source.getRefundCode());
        this.setOrderId(source.getOrderId());
        this.setOrderCode(source.getOrderCode());
        this.setStoreId(source.getStoreId());
        this.setUserId(source.getUserId());
        this.setSkuIdNums(source.getSkuIdNums());
        this.setRealBackPrice(source.getRealBackPrice());
        this.setStatus(source.getStatus());
        this.setRefundAt(source.getRefundAt());
        this.setErrorReason(source.getErrorReason());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }

    private static final GoblinNftOrderCallBackVo obj = new GoblinNftOrderCallBackVo();

    public static GoblinNftOrderCallBackVo getNew() {
        try {
            return (GoblinNftOrderCallBackVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinNftOrderCallBackVo();
    }
}
