package com.liquidnet.client.admin.web.controller.zhengzai.smile;

import com.alibaba.druid.support.json.JSONUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.zhengzai.smile.dto.*;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileUserService;
import com.liquidnet.service.smile.entity.SmileUser;
import com.liquidnet.service.smile.entity.dao.SmileUserCheckDao;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Api(tags = "用户管理,审核管理")
@Controller
@RequestMapping("/smile/user")
public class SmileUserController extends BaseController {

    @Autowired
    ISmileUserService iSmileUserService;

    @PostMapping("/list")
    @ApiOperation(value = "获取用户列表")
    @ResponseBody
    public TableDataInfo userList(SmileUserParam smileUserParam) {
        PageHelper.startPage(smileUserParam.getPageNum(), smileUserParam.getPageSize());
        return getDataTable(iSmileUserService.userList(smileUserParam));
    }

    @GetMapping("/getList")
    @ApiOperation(value = "获取用户列表")
    @ResponseBody
    public AjaxResult getList(String phone) {
        return AjaxResult.success(iSmileUserService.getList(phone));
    }

    @PostMapping("/getUserById")
    @ApiOperation(value = "根据ID查询单个用户完整信息")
    @ResponseBody
    public AjaxResult getUserById(@RequestParam(name = "uid", required = true) String uid) {
        SmileUserVo smileUser = iSmileUserService.getUserById(uid);
        return AjaxResult.success(smileUser);
    }

    @PostMapping("/getUserListByOrgId")
    @ApiOperation(value = "根据组织ID查询相人员信息")
    @ResponseBody
    public AjaxResult getUserListByOrgId(@RequestParam(name = "orgId", required = true) Long orgId, @RequestParam(name = "agentId", required = true) Long agentId) {
        List<SmileUserVoOrg> userListByOrgId = iSmileUserService.getUserListByOrgId(orgId, agentId);
        return AjaxResult.success(userListByOrgId);
    }

    @PostMapping("/check/list")
    @ApiOperation("获取审核列表")
    @ResponseBody
    public TableDataInfo list(UserCheckParam userCheckParam) {
        PageInfo<SmileUserCheckDao> list = iSmileUserService.listUserCheck(userCheckParam);
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(list.getList());
        rspData.setTotal(list.getTotal());
        return rspData;
    }

    @PostMapping("/check/updateById")
    @ApiOperation("修改审核  通过审核  1：总代，2：普代")
    @ResponseBody
    public AjaxResult updateById(@RequestBody SmileUserCheckVo smileUserCheckVo) {
        return iSmileUserService.updateUserCheckById(smileUserCheckVo);
    }

    @PostMapping("/updateUserStateByUid")
    @ApiOperation(value = "根据uid修改用户状态 0：正常，1：黑名单")
    @ResponseBody
    @ApiOperationSupport(order = 1)
    public AjaxResult updateUserStateById(@RequestBody SaveUserStateParam saveUserStateParam) {
        return iSmileUserService.updateUserStateById(saveUserStateParam.getUid(), saveUserStateParam.getState(),saveUserStateParam.getReason());
    }

    @PostMapping("/listByState")
    @ApiOperation("获取黑名单列表")
    @ResponseBody
    @ApiOperationSupport(order = 2)
    public TableDataInfo listByState(SmileUserStateParam smileUserStateParam) {
        PageHelper.startPage(smileUserStateParam.getPageNum(), smileUserStateParam.getPageSize());
        return getDataTable(iSmileUserService.listByState(smileUserStateParam));
    }

    @PostMapping("/saveInvitedAgent")
    @ApiOperation("新增特邀代理")
    @ResponseBody
    @ApiOperationSupport(order = 3)
    public AjaxResult saveInvitedAgent(@RequestBody SmileUserInvitedVo smileUserInvitedVo) {
        if (StringUtils.isEmpty(smileUserInvitedVo.getName())||
        StringUtils.isEmpty(smileUserInvitedVo.getDescribe())||
        StringUtils.isEmpty(smileUserInvitedVo.getPhone())||
        StringUtils.isEmpty(smileUserInvitedVo.getPerformancesId())||
        StringUtils.isNull(smileUserInvitedVo.getTicket())){
            return AjaxResult.warn("参数不能为空");
        }
        return iSmileUserService.saveInvitedAgent(smileUserInvitedVo);
    }


    @RequestMapping("getAreaJson")
    @ApiOperation("省市区json")
    @ResponseBody
    public AjaxResult getAreaJson() {
        String jsonStr = "";
        try {
            String path = Objects.requireNonNull(JSONUtils.class.getClassLoader().getResource("static/area.json")).getPath();
            logger.info("path:{}", path);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("static/area.json");
            if (inputStream != null) {
                Reader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                int ch = 0;
                StringBuilder sb = new StringBuilder();
                while ((ch = reader.read()) != -1) {
                    sb.append((char) ch);
                }
                reader.close();
                jsonStr = sb.toString();
                return AjaxResult.success(jsonStr);
            }
            return null;
        } catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}
