package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

import java.util.ArrayList;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 拉取数字商品历史登记记录
 * @class: Xuper013HistoryRespDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/8/12 17:50
 */
@Data
public class Xuper013HistoryRespDto {
    public long requestId;
    public int errNo;
    public String errMsg;
    public ArrayList<History> list;
    public int totalCnt;

    public static class History {
        public long assetId;
        public long type;
        public long shardId;
        public long price;
        public String txId;
        public String from;
        public String to;
        public long ctime;

        public long getAssetId() {
            return assetId;
        }

        public void setAssetId(long assetId) {
            this.assetId = assetId;
        }

        public long getType() {
            return type;
        }

        public void setType(long type) {
            this.type = type;
        }

        public long getShardId() {
            return shardId;
        }

        public void setShardId(long shardId) {
            this.shardId = shardId;
        }

        public long getPrice() {
            return price;
        }

        public void setPrice(long price) {
            this.price = price;
        }

        public String getTxId() {
            return txId;
        }

        public void setTxId(String txId) {
            this.txId = txId;
        }

        public String getFrom() {
            return from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public long getCtime() {
            return ctime;
        }

        public void setCtime(long ctime) {
            this.ctime = ctime;
        }
    }


    private static final Xuper013HistoryRespDto obj = new Xuper013HistoryRespDto();
    public static Xuper013HistoryRespDto getNew() {
        try {
            return (Xuper013HistoryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper013HistoryRespDto();
        }
    }
}
