package com.liquidnet.service.dragon.dto;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: DragonPayBaseReqDto
 * @Package com.liquidnet.service.dragon.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/9 10:56
 */
@Data
public class DragonPayBaseReqDto implements Serializable, Cloneable{
    private static final long serialVersionUID = -7273522103593077618L;
    private String payType;
    private String deviceFrom;
    private String openId;
    private String type;
    private BigDecimal price;
    private String name;
    private String detail;
    private String orderCode;
    private String orderId;
    private String clientIp;
    private String notifyUrl;
    private String code;
    private String createDate;
    private String expireTime;
    private String quitUrl;
    private String showUrl;
    private String returnUrl;
    private String authCode;
    // 苹果的
    private String receiptData;
    //苹果的stransactionId
    private String transactionId;
    //
    private String buyerOpenId;

    private String appIdType="";

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final DragonPayBaseReqDto obj = new DragonPayBaseReqDto();

    public static DragonPayBaseReqDto getNew() {
        try {
            return (DragonPayBaseReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new DragonPayBaseReqDto();
        }
    }
}
