package com.liquidnet.service.goblin.constant;

public class GoblinRedisConst {
    public static final String PREFIX = "goblin:";
    /* ----------------------------------------------------------------- */
    public static final String VALID_SMS_CODE_MOBILE = PREFIX.concat("valid:sms:code:mobile:");
    /* ----------------------------------------------------------------- */
    /**
     * IOS商品价格集
     * {goblin:bsc:lib:ios_products, JsonNode}
     */
    public static final String BASIC_LIB_IOS_PRODUCTS = PREFIX.concat("bsc:lib:ios_products");
    /**
     * 认证中店铺UID关系缓存
     * {goblin:bsc:ustore:${uid}, List<store_id>}
     */
    public static final String BASIC_USTORE = PREFIX.concat("bsc:ustore:");
    /**
     * 平台商品标签信息
     * {goblin:bsc:self_tag, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinSelfTagVo>)}
     */
    public static final String BASIC_SELF_TAG = PREFIX.concat("bsc:self_tag");
    /**
     * 平台专属标签信息
     * {goblin:bsc:self_etag, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinSelfTagVo>)}
     */
    public static final String BASIC_SELF_EXTAG = PREFIX.concat("bsc:self_etag");
    /**
     * 平台商品分类信息
     * {goblin:bsc:self_g_c, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinSelfGoodsCategoryVo>)}
     */
    public static final String BASIC_SELF_GOODS_CATEGORY = PREFIX.concat("bsc:self_g_c");
    /**
     * 平台商品分类信息
     * {goblin:bsc:self_g_c_s:${cate_id}, com.liquidnet.service.goblin.dto.manage.vo.GoblinMgtCategorySpecVo}
     */
    public static final String BASIC_SELF_GOODS_CATEGORY_SPEC = PREFIX.concat("bsc:self_g_c_s:");
    /**
     * 平台服务支持信息
     * {goblin:bsc:sev_sup, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinServiceSupportVo>)}
     */
    public static final String BASIC_SERVICE_SUPPORT = PREFIX.concat("bsc:sev_sup");
    /**
     * 店铺信息
     * {goblin:bsc:store:${store_id}, com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo}
     */
    public static final String BASIC_STORE = PREFIX.concat("bsc:store:");
    /**
     * 店铺配置信息
     * {goblin:bsc:store_cf:${store_id}, com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo}
     */
    public static final String BASIC_STORE_CONF = PREFIX.concat("bsc:store_cf:");
    /**
     * 店铺ERP配置信息
     * {goblin:bsc:store_ecf:${store_id}, com.liquidnet.service.goblin.dto.vo.GoblinStoreErpConfigVo}
     */
    public static final String BASIC_STORE_ERP_CONF = PREFIX.concat("bsc:store_ecf:");
    /**
     * 店铺ERP配置信息
     * {goblin:bsc:store_erps, List<shopNo>}
     */
    public static final String BASIC_STORE_ERPS = PREFIX.concat("bsc:store_erps");
    /**
     * 店铺商品分类信息
     * {goblin:bsc:store_g_c:${store_id}, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinStoreGoodsCategoryVo>)}
     */
    public static final String BASIC_STORE_GOODS_CATEGORY = PREFIX.concat("bsc:store_g_c:");
    /**
     * SPU信息
     * {goblin:bsc:goods:${spu_id}, com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo}
     */
    public static final String BASIC_GOODS = PREFIX.concat("bsc:goods:");
    public static final String BASIC_GOODS_UNSHELVES = PREFIX.concat("bsc:goods_unshelves:");
    /**
     * SKU信息
     * {goblin:bsc:goods_sku:${sku_id}, com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo}
     */
    public static final String BASIC_GOODS_SKU = PREFIX.concat("bsc:goods_sku:");
    public static final String BASIC_GOODS_SKU_UNSHELVES = PREFIX.concat("bsc:goods_sku_unshelves:");

    /* ----------------------------------------------------------------- */

    /**
     * 店铺公告
     * {goblin:store_ntc:${store_id}, com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo}
     */
    public static final String STORE_NOTICE = PREFIX.concat("store_ntc:");

    /* ----------------------------------------------------------------- */
    public static final String FRONT_TOP_BANNER = PREFIX.concat("front_top_banner");  //前端顶部banner
    public static final String FRONT_MIDDLE_BANNER = PREFIX.concat("front_middle_banner");  //前端中部banner
    public static final String FRONT_NAVIGATION = PREFIX.concat("front_navigation");  //前端banner
    public static final String FRONT_HOTWORD = PREFIX.concat("front_hot_word");  //前端banner
    public static final String FRONT_HOTWORD_INDEX = PREFIX.concat("front_hot_word_index");  //前端banner index
    public static final String FRONT_FRONT_SECKILL = PREFIX.concat("front_front_seckill");  //前端 首页秒杀
    public static final String FRONT_SECKILL = PREFIX.concat("front_seckill");  //前端 秒杀列表
    public static final String SELECT_GOODS = PREFIX.concat("select_goods");  //配置的精选商品
    public static final String SELECT_GOODS_PAGE1 = PREFIX.concat("select_goods_page1");  //精选商品 第一页
    public static final String SELECT_GOODS_SORT = PREFIX.concat("select_goods_sort");  //精选商品 排序规则
    public static final String SELECT_GOODS_SPUIDS = PREFIX.concat("select_goods_SPUIDS");  //精选商品 spuids
    public static final String SELECT_GOODS_SPUIDS_ISHAVE = PREFIX.concat("select_goods_SPUIDS_isHave");  //精选商品 spuids
    public static final String MOUDLE_INDEX = PREFIX.concat("moudle_index");  //moudle_index 组件排序
    public static final String COMPLIATIONS = PREFIX.concat("goblinFrontCompilations");  // 合集
    public static final String FRONT_GOBLINFRONTCUBE = PREFIX.concat("goblinFrontCube");  // 魔方
    public static final String FRONT_GOBLIN_RECOMMEND = PREFIX.concat("goblinFrontRECOMMMEND");  // 新品推荐
    public static final String FRONT_SHOPCART = PREFIX.concat("goblin_shopcart:");  // 购物车
    public static final String FRONT_SHOPCART_TWO = PREFIX.concat("goblin_shopcartTwo:");  // 购物车第二部


    /* ----------------------------------------------------------------- */
    public static final String REDIS_GOBLIN_MARKET_RELATION = PREFIX.concat("market:relation:");//商铺活动-商铺款式关联关系
    public static final String REDIS_GOBLIN_SELF_MARKET = PREFIX.concat("self:market:");//官方活动
    public static final String REDIS_GOBLIN_ZHENGZAI_RELATION = PREFIX.concat("zhengzai:market:");//活动-正在下单-可参加商户
    public static final String REDIS_GOBLIN_STORE_SELF_RELATION = PREFIX.concat("zhengzai:storeId:");//活动-当前商铺能参与的官方活动id列表
    public static final String REDIS_GOBLIN_STORE_MARKET = PREFIX.concat("store:market:");//商铺活动
    public static final String REDIS_GOBLIN_ZHENGZAI_LIST = PREFIX.concat("zhengzai:list");//全部正在下单内容

    public static final String REDIS_GOBLIN_STORE_MARKET_ISCONFIG = PREFIX.concat("store:is_config:");//商铺活动-该活动配置了款式的商品

    public static final String REDIS_GOBLIN_BUY_COUNT = PREFIX.concat("uid:");//用户sku购买数量 key:uid:skuId:$skuId

    public static final String REDIS_GOBLIN_BUY_COUNT_IDNO = PREFIX.concat("idcard:%s:%s:%s");// 实名sku购买数量 key:$idType:$idNo:$skuId
    public static final String REDIS_GOBLIN_SALE_COUNT = PREFIX.concat("sale:skuId:");//用户sku购买数量 key:sale:skuId:$skuId
    public static final String REDIS_GOBLIN_SALE_SPU_COUNT = PREFIX.concat("sale:spuId:");//用户sku购买数量 key:sale:skuId:$spuId
    public static final String REDIS_GOBLIN_ORDER = PREFIX.concat("order:");//用户sku购买数量 key:$orderId
    public static final String REDIS_GOBLIN_ORDER_BACK = PREFIX.concat("order:back:");//用户sku购买数量 key:$backOrderId
    public static final String REDIS_GOBLIN_ORDER_SKU = PREFIX.concat("orderSku:");//用户sku购买数量 key:$orderSkuId
    public static final String REDIS_GOBLIN_ORDER_UN_PAY = PREFIX.concat("order:un:pay:");//未支付订单id列表 key:$randomKey
    public static final String REDIS_GOBLIN_ORDER_LIST = PREFIX.concat("order:id:list:");//用户订单id列表 key:$uid
    public static final String REDIS_GOBLIN_ORDER_ZHENGZAI_LIST = PREFIX.concat("order:zhengzai:list:");//用户订单id列表 key:$uid
    public static final String REDIS_GOBLIN_ORDER_MASTER = PREFIX.concat("order:masterCode:");//用户订单id列表 key:$masterCode
    public static final String REDIS_GOBLIN_ORDER_MIX_MASTER = PREFIX.concat("order:mix:masterCode:");//用户订单id列表 key:$masterCode
    public static final String REDIS_GOBLIN_ORDER_OFFCODE = PREFIX.concat("order:offCode:");//用户订单id列表 key:$wtrieOffCode
    public static final String REDIS_GOBLIN_BACK_ORDER_ID = PREFIX.concat("order:backIds:");//用户订单下的退款订单id key:$orderId
    public static final String REDIS_CAN_BUY = PREFIX.concat("canBuy:");//可以购买的用户 key:$skuId:$mobile
    public static final String REDIS_ZZ_MUSIC_TAG = PREFIX.concat("music:tag:ZZ:");//根据场次音乐人标签搜索列表 key:$musicTag:$performanceId
    public static final String REDIS_GOBLIN_MAIL = PREFIX.concat("mail:orderId:");//快递 $key:$orderId
    public static final String REDIS_GOBLIN_TEMP_COUPON_MARKET = PREFIX.concat("temp:coupon:marketId:");//id 列表 $key:$marketId
    public static final String REDIS_GOBLIN_TEMP_COUPON = PREFIX.concat("temp:coupon:");//详情 $key:$ucouponId

    /* --------------------------------NFT--------------------------------- */
    public static final String REDIS_GOBLIN_NFT_ORDER_INFO = PREFIX.concat("nft:order:id:");// nft订单详情 orderId
    public static final String REDIS_GOBLIN_NFT_ORDER_ID_OF_CODE = PREFIX.concat("nft:order:code:");// nft订单ID获取 orderCode
    public static final String REDIS_GOBLIN_NFT_ORDER_USER_ID_LIST = PREFIX.concat("nft:order:idList:");// nft用户订单id列表 userId
    public static final String REDIS_GOBLIN_NFT_ORDER_REFUND_INFO = PREFIX.concat("nft:order:refund:");// nft退款订单详情 orderId
    public static final String REDIS_GOBLIN_NFT_ORDER_BUG_LOCK = PREFIX.concat("nft:order:lock:");// nft购买用户锁 userId
    public static final String REDIS_GOBLIN_NFT_ORDER_EX_LOCK = PREFIX.concat("nft:order:exLock:");// nft兑换码锁 code
    public static final String REDIS_GOBLIN_NFT_GOODS_LIST = PREFIX.concat("nft:goodsList");// nft商品列表
    public static final String REDIS_GOBLIN_NFT_GOODS_LIST_INFO = PREFIX.concat("nft:goodsList:info:");// nft商品列表单藏品详情 skuId
    public static final String REDIS_GOBLIN_NFT_NUM_ACCOUNT = PREFIX.concat("nft:account:");// nft用户数字账户是否开通 userId
    public static final String REDIS_GOBLIN_NFT_NUM_ACCOUNT_INFO = PREFIX.concat("nft:account:info:");// nft用户数字账户开通信息 userId
    public static final String REDIS_GOBLIN_NFT_NOT_PAY_NUM = PREFIX.concat("nft:notPay:");// nft藏品待支付订单数量 skuId:listId
    /**
     * {goblin:nft:certmeta:{idType+idNo},{idname,mobile}}
     */
    public static final String REDIS_GOBLIN_NFT_CERTMETA = PREFIX.concat("nft:certmeta:");
    public static final String REDIS_GOBLIN_NFT_CERTMETA_JUNK = PREFIX.concat("nft:certmeta_junk:");



    /* ----------------------------------------------------------------- */
    /**
     * SKU剩余库存
     */
    public static final String REAL_STOCK_SKU = PREFIX.concat("real_stock_sku:");
    public static final String SKU_RELATION = PREFIX.concat("sku:relation:");//$key:$skuId
    /* ----------------------------------------------------------------- */

    /**
     * 商铺活动:优惠券基本信息
     * {goblin:s_coupon:${store_coupon_id}, com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponVo}
     */
    public static final String STORE_COUPON = PREFIX.concat("s_coupon:");
    /**
     * 商铺活动:优惠券适用商品ID集合item
     * {goblin:s_coupon_r:${store_coupon_id}, JsonUtils.toJson(List<String:spu_id>)}
     */
    public static final String STORE_COUPON_RULE = PREFIX.concat("s_coupon_r:");
    /**
     * 商铺活动:优惠券剩余库存
     */
    public static final String STORE_COUPON_STOCK = PREFIX.concat("s_coupon_stock:");

    /* ----------------------------------------------------------------- */

    /**
     * 商铺活动ID集合
     * {goblin:store_markets:${store_id}, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.GoblinGoodsMarketDto>)}
     */
    public static final String STORE_MARKETS = PREFIX.concat("store_markets:");

    /* ----------------------------------------------------------------- */

    /**
     * 商城用户券
     * {golblin:user_coupon:${uid}, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinUserCouponVo>)}
     */
    public static final String USER_COUPON = PREFIX.concat("user_coupon:");

    /* ----------------------------------------------------------------- */

    /**
     * 我的藏品ID列表（首页）
     * {goblin:u_d_art_ids:${uid}, List<String:artwork_id>}
     */
    public static final String USER_DIGITAL_ARTWORK_IDS = PREFIX.concat("u_d_art_ids:");

    /**
     * 我的受赠藏品ID列表
     * {goblin:u_d_art_ids_tsf:${uid}, List<String:artwork_id>}
     */
    public static final String USER_DIGITAL_ARTWORK_IDS_TRANSFER = PREFIX.concat("u_d_art_ids_tsf:");

    /**
     * 我的藏品信息
     * {goblin:u_d_art:${artwork_id}, com.liquidnet.service.goblin.dto.vo.GoblinUserDigitalArtworkVo}
     */
    public static final String USER_DIGITAL_ARTWORK = PREFIX.concat("u_d_art:");

    /**
     * 我的藏品计数
     * {goblin:u_d_art_ct:${uid}, count(1)}
     */
    public static final String USER_DIGITAL_ARTWORK_CT = PREFIX.concat("u_d_art_ct:");

    /**
     * 我的藏品生成标记（有时效）
     * {goblin:u_d_art:${uid+skuId+orderId},1}
     */
    public static final String USER_DIGITAL_ARTWORK_GENMARK = PREFIX.concat("u_d_art_gm:");

    /* ----------------------------------------------------------------- */

    /**
     * 用户预约标识
     * {goblin:user:anticipate:${skuId}:${uid},(goblin_goods_anticipate_user)}
     */
    public static final String USER_ANTICIPATE_STATE = PREFIX.concat("user:anticipate:");

    /**
     * 真实预约人数
     * {goblin:anticipate:people:${autId},numPeople}
     */
    public static final String ANTICIPATE_PEOPLE = PREFIX.concat("anticipate:people:");

    /**
     * 记录sku
     */
    public static final String ANTICIPATE_SKUID = PREFIX.concat("anticipate:skuId:");

    /**
     * skuId保存预约用户头像
     * {anticipate:skuId:avatar:${skuId},List<String>}
     */
    public static final String ANTICIPATE_SKUID_AVATAR = PREFIX.concat("anticipate:skuId:avatar:");

    public static final String ANTICIPATE_VALUE_SKUID = PREFIX.concat("anticipate:value:skuid:");

    public static final String NFT_PAY_TYPE = PREFIX.concat("nft:payType");

    public static final String LIST_DETAILS = PREFIX.concat("list:");//名单列表详情 $key:$listId
    public static final String REDIS_BLACK = PREFIX.concat("black:");//黑名单 key:$listId:$skuId:$mobile
    public static final String REDIS_WHITE = PREFIX.concat("white:");//白名单 key:$listId:$skuId:$mobile
    public static final String LIST_COLLECT = PREFIX.concat("list:collect");//名单列表详情 $key:$skuId
    public static final String ADAM_IS_MEMBER = "kylin:member:uid:";//是否会员 $key:$uid
    public static final String LIST_RELATION_BOX = PREFIX.concat("list:relation:box");//名单列表详情 $key:$skuId:$listId
    /**
     * nft兑换活动配置
     */
    public static final String NFT_EX_ACTIVITY = PREFIX.concat("nft:ex:activity:");

    /**
     * nft兑换活动和sku的关联
     */
    public static final String NFT_EX_SKU = PREFIX.concat("nft:ex:sku:");

    /**
     * 兑换码
     */
    public static final String NFT_EX_CODE = PREFIX.concat("nft:ex:code:");

    /**
     * 用户sku兑换数量 activityId、skuId、userId
     */
    public static final String REDIS_GOBLIN_EX_BUY_COUNT = PREFIX.concat("nft:ex:buy:");


    /**
     * 用户助力
     */
    public static final String ANTICIPATE_SHARE_UID_SKUID = PREFIX.concat("anticipate:share:uid:skuId:");

    /**
     * skuId助力所需人数
     */
    public static final String ANTICIPATE_SHARE_SKUID_PEOPLE = PREFIX.concat("anticipate:share:skuId:people:");

    /**
     * 助力头像保存
     */
    public static final String ANTICIPATE_SHARE_HELP_AVATAR = PREFIX.concat("anticipate:share:help:avatar:");

    /**
     * 创建分享vo
     */
    public static final String ANTICIPATE_SHARE_VO = PREFIX.concat("anticipate:share:help:vo:");

    /**
     * 用户助力  助力人id:分享id
     */
    public static final String ANTICIPATE_SHARE_HELPID_SID = PREFIX.concat("anticipate:share:helpId:sid:");

    /**
     * 助力sid
     */
    public static final String ANTICIPATE_SHARE_SID = PREFIX.concat("anticipate:share:sid:");


    /**
     * 活动兑换码
     */
    public static final String ACTIVITY_SKU_CODE = PREFIX.concat("activity:sku:code:");

    /**
     * 兑换码sku时间
     */
    public static final String ACTIVITY_SKU_TIME = PREFIX.concat("activity:sku:time:");

    /**
     * 是否购买过技术数字藏品
     */
    public static final String BUY_NFT_TEC = PREFIX.concat("buy:nft:tec:");// $key+$uid 是否购买过技术数字藏品

    /**
     * 是否开启技术数字藏品特效
     */
    public static final String OPEN_NFT_TEC = PREFIX.concat("open:nft:tec:");//$key+$uid 是否开启技术数字藏品特效


    /**
     * 组合销售REDIS
     */
    public static final String GOBLIN_MIX_DETAILS = PREFIX.concat("mix:");//$key+$mixId
    public static final String GOBLIN_MIX_RELATION_BOX = PREFIX.concat("mix:relation:box");//库存关系 $key:$skuId:$listId
    public static final String GOBLIN_MIX_NFT_LIST = PREFIX.concat("mix:nft");//nft 混合售列表
    public static final String GOBLIN_MIX_SKU_LIST = PREFIX.concat("mix:goods");//nft 混合售列表

    public static final String GOBLIN_MIX_NFT_STOCK_LIST = PREFIX.concat("mix:nft:stock");//nft 混合售售罄列表
    public static final String GOBLIN_MIX_NFT_START_LIST = PREFIX.concat("mix:nft:start");//nft 混合售开始列表
    public static final String GOBLIN_MIX_SKU_STOCK_LIST = PREFIX.concat("mix:goods:stock");//sku 混合售售罄列表
    public static final String GOBLIN_MIX_SKU_START_LIST = PREFIX.concat("mix:goods:start");//sku 混合售开始列表


    public static final String GOBLIN_MIX_LIMIT = PREFIX.concat("mix:limit:");//$key:$mixId:$uid 混合售开始列表


    public static final String GOBLIN_MIX_RESERVE_UID = PREFIX.concat("mix:reserve:uid:");//$mixId:$uid 混合售用户预约保存

    public static final String GOBLIN_RECHARGE_WRISTBAND = PREFIX.concat("recharge:wristband");
    public static final String GOBLIN_RECHARGE_MAIZHI_TOKEN = PREFIX.concat("recharge:maizhitoken");

    // 手环订单
    public static final String GOBLIN_BRACELET_USER = PREFIX.concat("bracelet:userId:");

    /* ----------------------------------------------------------------- */
    public static final String GOBLIN_ORDER_LOG = PREFIX.concat("order:log:");//无用
    public static final String GOBLIN_EXPRESS_PRICE = PREFIX.concat("express:price");//快递费

    /* ----------------------------------------------------------------- */
    public static final String GOBLIN_NUM_LIST = PREFIX.concat("nft:num:");//$key+":"+$skuId 根据skuId获取序号list
    public static final String GOBLIN_NUM_DETAILS = PREFIX.concat("nft:num:details:");//$key+$num+$skuId 根据num+skuId获取DTO

    /* ----------------------------------------------------------------- */

    /**
     * NFT用户安全配置
     * {goblin:u_safe_c:${uid}, com.liquidnet.service.goblin.dto.GoblinUserSafeConfigDto}
     */
    public static final String USER_SAFE_CONFIG = PREFIX.concat("u_safe_c:");

    /**
     * NFT用户安全密码临时锁定时间段配置（单位：分钟，默认30分钟）
     * {goblin:u_safe_lk:passwdtl:timelimit, seconds}
     */
    public static final String USER_SAFE_LK_PASSWDTL_TIMELIMIT = PREFIX.concat("u_safe_lk:passwdtl:timelimit");

    /**
     * NFT用户安全密码临时锁定KEY
     * {goblin:u_safe_lk:passwdtl:${uid}, number++}
     */
    public static final String USER_SAFE_LK_PASSWDTL = PREFIX.concat("u_safe_lk:passwdtl:");

    /**
     * NFT用户安全密码锁定KEY
     * {goblin:u_safe_lk:passwd:${uid}, number++}
     */
    public static final String USER_SAFE_LK_PASSWD = PREFIX.concat("u_safe_lk:passwd:");

    /**
     * NFT转赠约束配置（首次转赠）
     * {goblin:nft_trans_conf, "${routeType:timeLimit0},${routeType:timeLimit1},${routeType:timeLimit2}..."}
     */
    public static final String NFT_TRANSFER_CONF = PREFIX.concat("nft_trans_conf");

    /**
     * NFT转赠约束配置（二次转赠）
     * {goblin:nft_trans_conf_again, "${routeType:timeLimit0},${routeType:timeLimit1},${routeType:timeLimit2}..."}
     */
    public static final String NFT_TRANSFER_CONF_AGAIN = PREFIX.concat("nft_trans_conf_again");


    /**
     * 商铺离线券
     */
    public static final String STORE_OUT_LINE_COUPON = PREFIX.concat("out_coupon");
    /* ----------------------------------------------------------------- */


    public static final String ERP_GOBLIN_GOODS_LIST = PREFIX.concat("erp:push:order:");
    /* ----------------------------------------------------------------- */
    /* ----------------------------------------------------------------- */
    /* ----------------------------------------------------------------- */
    /* ----------------------------------------------------------------- */
}
