package com.liquidnet.service.adam.dto.param.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel(value = "AdamMemberCodeListParam", description = "会员码列表入参")
@Data
public class AdamMemberCodeGenParam implements Serializable {
    private static final long serialVersionUID = 7212595876649709617L;
    @NotBlank(message = "会员类型ID不能为空")
    @ApiModelProperty(required = true, value = "会员类型ID[64]", example = "1")
    private String memberId;
    @NotBlank(message = "会员价格ID不能为空")
    @ApiModelProperty(required = true, value = "会员价格ID[64]", example = "1")
    private String memberPriceId;
    @NotNull(message = "有效期不能为空")
    @ApiModelProperty(required = true, value = "有效期", example = "30")
    private Integer validity;
    @NotNull(message = "生成数量不能为空")
    @Min(1)
    @Max(100)
    @ApiModelProperty(required = true, value = "生成数量[1-100]", example = "1")
    private Integer genNum;
}
