package com.liquidnet.service.merchant.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 演出授权记录表
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MerchantAuthorizationRecords implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * authorization_record_id
     */
    private String authorizationRecordId;

    /**
     * 演出ID
     */
    private String performanceId;

    /**
     * 权利人演出角色[creator|sponsor|fielder|checker]
     */
    private String uidRole;

    /**
     * 权利人
     */
    private String uid;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 姓名
     */
    private String name;

    /**
     * 授权人演出角色[creator|sponsor|fielder]
     */
    private String cuidRole;

    /**
     * 授权人
     */
    private String cuid;

    private LocalDateTime deletedAt;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
