package com.liquidnet.service.merchant.service;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.merchant.constant.MerchantRedisConst;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldAppliesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldCheckersVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.liquidnet.service.merchant.dto.vo.MerchantSponsorAppliesVo;
import com.liquidnet.service.merchant.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Slf4j
@Service
public class MerchantRdmService {

    @Autowired
    RedisUtil redisUtil;

    public MerchantFieldsVo getFieldsVoByFieldId(String fieldId) {
        String key = MerchantRedisConst.INFO_FIELD.concat(fieldId);
        long s = System.currentTimeMillis();
        MerchantFieldsVo vo = (MerchantFieldsVo) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        return vo;
    }

    public boolean setFieldsVoByFieldId(String fieldId, MerchantFieldsVo vo) {
        return redisUtil.set(MerchantRedisConst.INFO_FIELD.concat(fieldId), vo);
    }


    public List<MerchantFieldAppliesVo> getFieldAppliesVosByUid(String uid) {
        String key = MerchantRedisConst.INFO_FIELD_APPLIES.concat(uid);
        long s = System.currentTimeMillis();
        List<MerchantFieldAppliesVo> vos = (List<MerchantFieldAppliesVo>) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        return vos;
    }

    public boolean addFieldAppliesVoByUid(String uid, List<MerchantFieldAppliesVo> vos, MerchantFieldAppliesVo vo) {
        if (null == vos) {
            vos = ObjectUtil.getMerchantFieldAppliesVoArrayList();
        }
        vos.add(vo);
        return redisUtil.set(MerchantRedisConst.INFO_FIELD_APPLIES.concat(uid), vos);
    }

    public boolean delFieldAppliesVoByUid(String uid, List<MerchantFieldAppliesVo> vos, MerchantFieldAppliesVo vo) {
        if (CollectionUtils.isEmpty(vos)) {
            return true;
        }
        vos.removeIf(r -> r.getFieldApplyId().equals(vo.getFieldApplyId()));
        return redisUtil.set(MerchantRedisConst.INFO_FIELD_APPLIES.concat(uid), vos);
    }


    public List<MerchantFieldCheckersVo> getFieldCheckersVosByFieldId(String fieldId) {
        String key = MerchantRedisConst.INFO_FIELD_CHECKERS.concat(fieldId);
        long s = System.currentTimeMillis();
        List<MerchantFieldCheckersVo> vos = (List<MerchantFieldCheckersVo>) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        return vos;
    }

    public boolean addFieldCheckersVoByFieldId(String fieldId, List<MerchantFieldCheckersVo> vos, MerchantFieldCheckersVo vo) {
        if (null == vos) {
            vos = ObjectUtil.getMerchantFieldCheckersVoArrayList();
        }
        vos.add(vo);
        return redisUtil.set(MerchantRedisConst.INFO_FIELD_CHECKERS.concat(fieldId), vos);
    }

    public boolean delFieldCheckersVoByFieldId(String fieldId, List<MerchantFieldCheckersVo> vos,  MerchantFieldCheckersVo vo) {
        if (CollectionUtils.isEmpty(vos)) {
            return true;
        }
        vos.removeIf(r -> r.getFieldCheckerId().equals(vo.getFieldCheckerId()));
        return redisUtil.set(MerchantRedisConst.INFO_FIELD_CHECKERS.concat(fieldId), vos);
    }


    public List<MerchantSponsorAppliesVo> getSponsorAppliesVosByUid(String uid) {
        String key = MerchantRedisConst.INFO_SPONSOR_APPLIES.concat(uid);
        long s = System.currentTimeMillis();
        List<MerchantSponsorAppliesVo> vos = (List<MerchantSponsorAppliesVo>) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        return vos;
    }

    public boolean addSponsorAppliesVoByUid(String uid, List<MerchantSponsorAppliesVo> vos, MerchantSponsorAppliesVo vo) {
        if (null == vos) {
            vos = ObjectUtil.getMerchantSponsorAppliesVoArrayList();
        }
        vos.add(vo);
        return redisUtil.set(MerchantRedisConst.INFO_SPONSOR_APPLIES.concat(uid), vos);
    }

    public boolean delSponsorAppliesVoByUid(String uid, List<MerchantSponsorAppliesVo> vos, MerchantSponsorAppliesVo vo) {
        if (CollectionUtils.isEmpty(vos)) {
            return true;
        }
        vos.removeIf(r -> r.getSponsorApplyId().equals(vo.getSponsorApplyId()));
        return redisUtil.set(MerchantRedisConst.INFO_SPONSOR_APPLIES.concat(uid), vos);
    }
}
