package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT购买(涉及NFT发行、NFT购买)
 * @class: GalaxyNftPublishAndBuyReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/17 13:51
 */
@ApiModel(value = "GalaxyNftPublishAndBuyReqDto", description = "NFT发行购买")
@Data
public class GalaxyNftPublishAndBuyRouterBatchQueryReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
    @NotBlank(message = "用户ID不能为空！")
    @Size(min = 1, max = 30, message = "用户ID限制2-30位且不能包含特殊字符")
    private String userId;

    @ApiModelProperty(position = 1, required = true, value = "nft订单支付id")
    private List<String> nftOrderPayIdList;


    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftPublishAndBuyRouterBatchQueryReqDto obj = new GalaxyNftPublishAndBuyRouterBatchQueryReqDto();

    public static GalaxyNftPublishAndBuyRouterBatchQueryReqDto getNew() {
        try {
            return (GalaxyNftPublishAndBuyRouterBatchQueryReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftPublishAndBuyRouterBatchQueryReqDto();
        }
    }
}
