package com.liquidnet.service.kylin.dto.vo.mongo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class KylinOrderTicketEntitiesForOrderVo implements Serializable, Cloneable {

    private String orderId;
    private String timeId;
    @ApiModelProperty("演出名称")
    private String performanceTitle;
    @ApiModelProperty("票种名称")
    private String ticketTitle;
    @ApiModelProperty("场次开始")
    private String useStart;
    @ApiModelProperty("场次开始结束")
    private String useEnd;
    @ApiModelProperty("isPayment")
    private Integer isPayment;

    private static final KylinOrderTicketEntitiesForOrderVo obj = new KylinOrderTicketEntitiesForOrderVo();

    public static KylinOrderTicketEntitiesForOrderVo getNew() {
        try {
            return (KylinOrderTicketEntitiesForOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderTicketEntitiesForOrderVo();
        }
    }
}
