package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 8.图片内容检测
 * @class: QueryImageModerationReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:26
 */
@Data
public class Nft008QueryImageModerationReq implements Serializable {
    /**
     * 素材地址(全路径)
     */
    private String imageUrl;
    /**
     * 截帧频率，GIF图/长图检测专用，默认值为0，表示只会检测GIF图/长图的第一帧
     */
    //@Null
    private Integer intrval;
    /**
     * GIF图/长图检测专用，代表均匀最大截帧数量，默认值为1（即只取GIF第一张，或长图不做切分处理(可能会造成处理超时)）
     */
    //@Null
    private Integer maxFrames;
    private static final Nft008QueryImageModerationReq obj = new Nft008QueryImageModerationReq();
    private static final long serialVersionUID = 6578525145142483650L;

    public static Nft008QueryImageModerationReq getNew() {
        try {
            return (Nft008QueryImageModerationReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft008QueryImageModerationReq();
        }
    }
}
