package com.liquidnet.service.kylin.service;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.tmp.CourierListVo;
import com.liquidnet.service.kylin.dto.vo.tmp.KuaidiAdminParam;
import com.liquidnet.service.kylin.dto.vo.tmp.KuaidiReturn;
import com.liquidnet.service.kylin.entity.ExpressBatches;
import com.liquidnet.service.kylin.entity.Expresses;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * <p>
 * 快递表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-26
 */
public interface IExpressesService extends IService<Expresses> {

    /**
     * 根据订单ID查询快递信息
     * order_id ：订单号
     * type：订单类型 （订单类型 order_product 商品订单 , order_ticket 票务订单, order_integration 积分订单）
     */
    ResponseDto<CourierListVo> courierList(String orderId, String type);

    /**
     * 快递100 订阅接«口
     * company 快递公司
     * number  快递单号
     */
    KuaidiReturn observer(String company , String number);
    void observerResult(String param);
    String addExpress(KuaidiAdminParam param);
    String editExpress(KuaidiAdminParam param);
    String getExpressCompany(String name);
    String getExpressCompanyEn(String name);
    String innerAddExpress(KuaidiAdminParam param);
    PageInfo<ExpressBatches> expressObserveUnSuccess(int page , int size);
//    void expressBatchImport(); // 批量导入
//    void expressImport(); // 单条导入
//    void expressEdit(); // 编辑快递收货地址
//    void expressEditLog(); //快递收货地址修改记录
}
