package com.liquidnet.service.sequence.service.processor;

import com.liquidnet.service.sequence.service.IDGenerator;
import com.liquidnet.service.sequence.service.SysSequenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysIncrementProcessor extends IDGenerator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SysSequenceService sysSequenceService;

    @Override
    public Long nextId(String key) {
        return sysSequenceService.generateSeqNo(key);
    }
}
