package com.liquidnet.service.kylin.controller;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.WqTempParam;
import com.liquidnet.service.kylin.dto.vo.CheckData;
import com.liquidnet.service.kylin.dto.vo.WqTempVo;
import com.liquidnet.service.kylin.service.IKylinTempService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Api(tags = "pda验票接口")
@RestController
@RequestMapping("pda")
@Slf4j
public class CheckDataController {

    @Autowired
    private IKylinTempService kylinTempService;

    @GetMapping("checked")
    @ApiOperation("查询入场的已检票数据")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performance_id", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "idcode", value = "证件号", required = true),
            @ApiImplicitParam(type = "query", dataType = "ArrayList", name = "ticket_ids", value = "票id", required = true),

    })
    public HashMap<String, Object> getCheckData(String performance_id, String idcode, String[] ticket_ids) {
        HashMap<String, Object> map = CollectionUtil.mapStringObject();
        map.put("check_data", kylinTempService.getCheckData(performance_id, idcode, ticket_ids).getData());
        return map;
    }

    @PostMapping("check")
    @ApiOperation("检票")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performance_id", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "idcode", value = "证件号", required = true),
            @ApiImplicitParam(type = "query", dataType = "ArrayList", name = "ticket_ids", value = "票id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "remarks", value = "设备号", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "check_time", value = "验票时间", required = true),
    })
    public HashMap<String, Object> checkTicket(String performance_id, String idcode, String remarks, String[] ticket_ids, String check_time) {
        HashMap<String, Object> map = CollectionUtil.mapStringObject();
        map.put("check_data", kylinTempService.checkTicket(performance_id, idcode, remarks, ticket_ids, check_time).getData());
        map.put("check_time", check_time);
        return map;
    }

}
