package com.liquidnet.service.kylin.constant;

/**
 * <p>
 * Kylin表状态常量定义
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 6:38 下午
 */
public class KylinTableStatusConst {
    /**
     * 退款
     */
    // 批量退款 1处理完成 11 处理中
    public static final Integer STATUS_APPLY = 1; // 1申请退款
    public static final Integer STATUS_APPLY11 = 11;
    public static final Integer STATUS_CANCEL = 2; // 2取消退款
    public static final Integer STATUS_CANCEL22 = 22;
    public static final Integer STATUS_OPERATE_REJECT = 3; // 3运营驳回审核
    public static final Integer STATUS_OPERATE_REJECT33 = 33;
    public static final Integer STATUS_OPERATE_ADOPT = 4; // 4运营通过审核
    public static final Integer STATUS_OPERATE_ADOPT44 = 44;
    public static final Integer STATUS_FINANCE_REJECT = 5; // 5财务驳回审核
    public static final Integer STATUS_FINANCE_REJECT55 = 55;
    public static final Integer STATUS_FINANCE_ADOPT = 6; // 6财务通过审核
    public static final Integer STATUS_FINANCE_ADOPT66 = 66;

    // 退款
    public static final Integer ORDER_REFUND_STATUS_APPLY = 0; // 请求退款
    public static final Integer ORDER_REFUND_STATUS_APPROVED = 1; // 运营审核同意 审核通过
    public static final Integer ORDER_REFUND_STATUS_CANCEL = 2; // 取消退款
    public static final Integer ORDER_REFUND_STATUS_REFUNDED = 4; // 完成退款
    public static final Integer ORDER_REFUND_STATUS_REJECT = 5; // 运营审核驳回退款 等同取消
    public static final Integer ORDER_REFUND_STATUS_ERROR = 6; // 退款失败
    public static final Integer ORDER_REFUND_STATUS_UNFILLED = 7; // 财务审核同意 等待退款
    public static final Integer ORDER_REFUND_STATUS_REFUSE = 8; // 财务审核拒绝
    public static final Integer ORDER_REFUND_STATUS_TICKET = 9; // 票务确认收货

    public static final Integer ORDER_REFUND_TYPE_APPLY = 0; // 客服、票务人工申请，可以取消退款，回调再处理库存和券
    public static final Integer ORDER_REFUND_TYPE_APPLY2 = 2; // 用户申请普通退款，可以取消退款，回调再处理库存和券
    public static final Integer ORDER_REFUND_TYPE_APPLY3 = 3; // 用户申请快递退款，可以取消退款，回调再处理库存和券，需确认收货
    public static final Integer ORDER_REFUND_TYPE_AUTO = 1; // 超时退款，无法取消退款，直接返还库存和券，回调不再处理库存和券

    /**
     * 订单状态表状态
     */
    // 订单状态
    public static final Integer ORDER_STATUS0 = 0;    // 待付款
    public static final Integer ORDER_STATUS1 = 1;    // 已付款
    public static final Integer ORDER_STATUS2 = 2;    // 已关闭
    public static final Integer ORDER_STATUS3 = 3;    // 正在退款
    public static final Integer ORDER_STATUS4 = 4;    // 已退款
    public static final Integer ORDER_STATUS5 = 5;    // 待关闭
    public static final Integer ORDER_STATUS6 = 6;    // 部分退款
    // 支付状态
    public static final Integer ORDER_PAY_STATUS0 = 0;    // 未支付
    public static final Integer ORDER_PAY_STATUS1 = 1;    // 已支付
    public static final Integer ORDER_PAY_STATUS2 = 2;    // 支付不失败
    // 转增
    public static final Integer ORDER_TRANSFER_STATUS0 = 0;    // 未转移
    public static final Integer ORDER_TRANSFER_STATUS1 = 1;    // 收到他人转赠
    public static final Integer ORDER_TRANSFER_STATUS2 = 2;    // 已转赠给他人

    /**
     * 入场人表状态
     */
    // 支付状态
    public static final Integer ENTITIES_IS_PAYMENT0 = 0;    // 未支付
    public static final Integer ENTITIES_IS_PAYMENT1 = 1;    // 已支付
    public static final Integer ENTITIES_IS_PAYMENT2 = 2;    // 退款中
    public static final Integer ENTITIES_IS_PAYMENT3 = 3;    // 已退款
    public static final Integer ENTITIES_IS_PAYMENT4 = 4;    // 部分退款
    // 出票状态
    public static final Integer ENTITIES_STATUS0 = 0;    // 未出票
    public static final Integer ENTITIES_STATUS1 = 1;    // 已出票

    /**
     * 快递
     */
    public static final Integer ORDER_EXPRESS_STATUS1 = 1;    // 申请 顺丰返回失败 未下单 未发快递
    public static final Integer ORDER_EXPRESS_STATUS2 = 2;    // 申请 顺丰返回成功 或 通过主动再查询更新
    public static final Integer ORDER_EXPRESS_STATUS3 = 3;    // 取消
    public static final Integer ORDER_EXPRESS_STATUS80 = 80;    // 签收
    public static final Integer ORDER_EXPRESS_STATUS8000 = 8000;    // 签收结单
    public static final Integer ORDER_EXPRESS_SEND_TYPE1 = 1;    // 发货
    public static final Integer ORDER_EXPRESS_SEND_TYPE2 = 2;    // 退款


    public enum PvUv {
        TK_DETAILS("now_tk_detail", "详情页"),
        TK_TICKET("now_tk_ticket", "票种页"),
        TK_ORDER("now_tk_order", "预下单页"),
        TK_PAY("now_tk_pay", "支付操作");
        private final String key;
        private final String desc;

        PvUv(String key, String desc) {
            this.key = key;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getDesc() {
            return desc;
        }
    }
    
    /**
     * 演出预约提醒类型
     * @author zjp
     * @return: null
     * @date 2024/3/14 11:31
    */
    public enum SubscribeTypeEnum {
        TYPE1(0, "开票提醒");
        private final Integer key;
        private final String desc;

        SubscribeTypeEnum(Integer key, String desc) {
            this.key = key;
            this.desc = desc;
        }

        public Integer getKey() {
            return key;
        }

        public String getDesc() {
            return desc;
        }
    }
}

