package com.liquidnet.service.sweet.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.sweet.entity.SweetLostFoundAdmin;
import com.liquidnet.service.sweet.param.SweetLostFoundAdminParam;
import com.liquidnet.service.sweet.vo.SweetLostFoundAdminVo;

import java.util.List;

/**
 * 失物招领管理员服务接口
 *
 * @author liquidnet
 * @since 2025-01-18
 */
public interface ISweetLostFoundAdminService extends IService<SweetLostFoundAdmin> {

    /**
     * 添加管理员
     *
     * @param admin 管理员信息
     * @return 是否成功
     */
    boolean addAdmin(SweetLostFoundAdminParam admin);

    /**
     * 编辑管理员
     *
     * @param admin 管理员信息
     * @return 是否成功
     */
    boolean editAdmin(SweetLostFoundAdminParam admin);

    /**
     * 删除管理员
     *
     * @param id 管理员ID
     * @return 是否成功
     */
    boolean deleteAdmin(Long id);

    /**
     * 获取管理员详情
     *
     * @param id 管理员ID
     * @return 管理员详情
     */
    SweetLostFoundAdminVo getAdminDetail(Long id);

    /**
     * 分页查询管理员列表
     *
     * @param performanceId 查询参数
     * @return 分页结果
     */
    List<SweetLostFoundAdminVo> getAdminList(String performanceId);

    /**
     * 检查是否有管理员权限
     *
     * @param phone         手机号
     * @param performanceId 演出ID
     * @return 权限详情信息
     */
    SweetLostFoundAdminVo hasPermission(String phone, String performanceId);

}