package com.liquidnet.service.goblin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.goblin.entity.GoblinNftExCodeTaskRelation;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * 兑换码定时任务生成副表 Mapper 接口
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-28
 */
@Repository
public interface GoblinNftExCodeTaskRelationMapper extends BaseMapper<GoblinNftExCodeTaskRelation> {

    /**
     * 根据定时任务ids查询
     * @param taskIds
     * @return
     */
    List<GoblinNftExCodeTaskRelation> selectByTaskIds(@Param("taskIds") String taskIds);

    /**
     * 批量添加定时任务附表
     * @param goblinNftExCodeTaskRelations
     * @return
     */
    int inserts(@Param("goblinNftExCodeTaskRelations") List<GoblinNftExCodeTaskRelation> goblinNftExCodeTaskRelations);
}
