package com.liquidnet.service.kylin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.kylin.dao.*;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 演出 Mapper 接口
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
public interface KylinPerformancesMapper extends BaseMapper<KylinPerformances> {

    //列表
    List<PerformancePartnerListDao> partnerPerformanceList(Map<String,Object> map);

    //列表
    List<PerformanceAdminListDao> misPerformanceList(Map<String,Object> map);

    //根据巡演查询 通过审核演出列表
    List<PerformanceTitleDao> misTitleByRoadShowIdList(String roadShowId);

    //根据巡演查询 通过审核演出列表
    List<PerformanceTitleDao> misTitleByStatusList(@Param("status") String status, @Param("title") String title);

    //根据演出id 搜索到下面全部场次票
    List<PerformanceSimpleAllDao> misPerformanceDetail(@Param("performanceList") List<String> performanceList);

    //推荐列表
    List<PerformanceRecommendAdminDao> reCommendPerformanceList();

    //演出 会员演出相关信息
    PerformanceTitleDao misPerformanceMemberInfo(String performancesId);

    //演出 会员票相关信息
    List<TicketMemberAuditDao> misTicketMemberInfo(String performancesId);

    //演出 会员票相关信息
    PerformanceRecommendDao getRecommend(String performancesId);

    List<PerformanceOrderStatisticalDao> getPerformanceOrderStatisticalList(String performancesId);

    List<PerformanceSponsorDao> getPerformanceSponsorList(String sponsorType);

    List<PerformanceExpressPerformanceListAdminDao> performanceExpressPerformanceList(Map<String, Object> map);

    PerformanceExpressPerformanceListAdminDao countExpressNumber(String performancesId);

    List<OrderExportDao> exportOrderByPerformanceIdAll(String performancesId);
    List<OrderExportDao> exportOrderByPerformanceIdPay(String performancesId);

    PerformanceSimpleAllDao getPerformanceSimpleByPerformancesId(String performancesId);
    PerformanceSimpleAllDao getPerformanceSimpleByTimesId(String timesId);
    PerformanceSimpleAllDao getPerformanceSimpleByTicketId(String ticketId);

    void updateComment(@Param("sort") String sort);

    void updateCommentByPer(@Param("sort") String sort,@Param("performancesId") String performancesId);

    List<KylinPerformances> selectByComment();

    List<KylinPerformances> selectPerIdByAgent();

    List<KylinPerformancesDao> selectTicketIdByPerId(@Param("performancesId") String performancesId);

    //订单时间查订单信息
    List<OrderExportDao> exportOrderByOrderTime(@Param("beginTime") Date beginTime, @Param("endTime") Date endTime);
    //演出时间查订单信息
    List<OrderExportDao> exportOrderByShowTime(@Param("beginTime") Date beginTime, @Param("endTime") Date endTime);
    //演出id查订单信息
    List<OrderExportDao> exportOrderByShowId(@Param("showId") String showId);
    //会员订单信息
    List<MemberOrderExportDao> exportMemberOrder(@Param("beginTime") Date beginTime, @Param("endTime") Date endTime);
    //商品订单信息
    List<CommodityOrderExportDao> exportCommodityOrder(@Param("beginTime") Date beginTime, @Param("endTime") Date endTime);

}
