package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.smile.entity.SmileVolunteers;
import com.liquidnet.service.smile.entity.SmileVolunteersProject;
import com.liquidnet.service.smile.entity.SmileVolunteersTeam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * @author 志愿者活动创建修改
 */
@Data
public class SmileVolunteersDetailsVo implements Cloneable {
    @ApiModelProperty(value = "用户id", example = "")
    private String uid;
    @ApiModelProperty(value = "活动Id", example = "")
    private String projectId;
    @ApiModelProperty(value = "活动名称", example = "")
    private String projectName;
    @ApiModelProperty(value = "姓名", example = "")
    private String name;
    @ApiModelProperty(value = "头像", example = "")
    private String img;
    @ApiModelProperty(value = "证件号", example = "")
    private String idCard;
    @ApiModelProperty(value = "性别", example = "")
    private Integer sex;
    @ApiModelProperty(value = "审核状态", example = "")
    private Integer status;
    @ApiModelProperty(value = "学校", example = "")
    private String school;
    @ApiModelProperty(value = "学校地址", example = "")
    private String schoolAddress;
    @ApiModelProperty(value = "专长", example = "")
    private String specialty;
    @ApiModelProperty(value = "特长", example = "")
    private String specialty2;
    @ApiModelProperty(value = "手机号", example = "")
    private String phone;
    @ApiModelProperty(value = "自我介绍", example = "")
    private String introduce;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createdAt;
    @ApiModelProperty(value = "职责组集合", example = "")
    private List<SmileVolunteersTeam> teamArray;

    private static final SmileVolunteersDetailsVo obj = new SmileVolunteersDetailsVo();

    public static SmileVolunteersDetailsVo getNew() {
        try {
            return (SmileVolunteersDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SmileVolunteersDetailsVo();
        }
    }

    public SmileVolunteersDetailsVo copy(SmileVolunteers source, List<SmileVolunteersTeam> teamList,String projectName) {
        this.setUid(source.getUid());
        this.setProjectId(source.getProjectId());
        this.setProjectName(projectName);
        this.setName(source.getName());
        this.setImg(source.getImg());
        this.setIdCard(source.getIdCard());
        this.setSex(source.getSex());
        this.setStatus(source.getStatus());
        this.setSchool(source.getSchool());
        this.setSchoolAddress(source.getSchoolAddress());
        this.setSpecialty(source.getSpecialty());
        this.setSpecialty2(source.getSpecialty2());
        this.setPhone(source.getPhone());
        this.setIntroduce(source.getIntroduce());
        this.setCreatedAt(source.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        this.setTeamArray(teamList);
        return this;
    }
}
