package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinSelfGoodsTagVo", description = "标签信息")
@Data
public class GoblinSelfGoodsTagVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -2342407105969740471L;
    @ApiModelProperty(position = 11, value = "标签ID")
    private String tagId;
    @ApiModelProperty(position = 12, value = "标签名称")
    private String tagName;
    @ApiModelProperty(position = 13, value = "排序[数值越小,排序越前]")
    private Integer sort;

    private static final GoblinSelfGoodsTagVo obj = new GoblinSelfGoodsTagVo();
    public static GoblinSelfGoodsTagVo getNew() {
        try {
            return (GoblinSelfGoodsTagVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinSelfGoodsTagVo();
        }
    }
}
