package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreCertificationVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

@ApiModel(value = "GoblinStoreMgtCertificationParam", description = "店铺认证:认证资料入参")
@Data
public class GoblinStoreMgtCertificationParam implements java.io.Serializable {
    private static final long serialVersionUID = 6674618707269625280L;
    @ApiModelProperty(position = 11, value = "认证类型[1-企业/公司|2-个体工商户]", allowableValues = "1,2", example = "2")
    @NotBlank(message = "认证类型不能为空")
    @Pattern(regexp = "\\b(1|2)\\b", message = "认证类型无效")
    private String certType;
    @ApiModelProperty(position = 12, value = "证件类型[1-二代居民身份证]", allowableValues = "1", example = "1")
    @Pattern(regexp = "\\b(1)\\b", message = "证件类型无效")
    private String personCertType;
    @ApiModelProperty(position = 13, value = "证件姓名[32]", example = "张三")
    private String personName;
    @ApiModelProperty(position = 14, value = "证件号码[32]", example = "111111111111111111")
    private String personCertCode;
    @ApiModelProperty(position = 15, value = "证件有效期[YYYY-MM-DD]", example = "2022-12-31")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "证件有效期格式有误")
    private String personCertValidity;
    @ApiModelProperty(position = 16, value = "证件是否长期有效[0-否|1-是]", example = "0")
    @NotBlank(message = "证件是否长期有效不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "证件是否长期有效参数无效")
    private String personCertLasting;
    @ApiModelProperty(position = 17, value = "证件正面照[256]")
    private String personCertFpic;
    @ApiModelProperty(position = 18, value = "证件背面照[256]")
    private String personCertBpic;
    @ApiModelProperty(position = 19, value = "证件手持照[256]")
    private String personCertSpic;

    @ApiModelProperty(position = 19, value = "省ID[20]", example = "110000")
    private String provinceId;
    @ApiModelProperty(position = 20, value = "省名称[32]", example = "北京市")
    private String provinceName;
    @ApiModelProperty(position = 21, value = "市ID[20]", example = "110100")
    private String cityId;
    @ApiModelProperty(position = 22, value = "市名称[32]", example = "北京")
    private String cityName;
    @ApiModelProperty(position = 23, value = "县ID[20]", example = "110105")
    private String countyId;
    @ApiModelProperty(position = 24, value = "县名称[32]", example = "朝阳区")
    private String countyName;
    @ApiModelProperty(position = 25, value = "详细地址[128]", example = "XXXXX")
    private String busAddress;

    @ApiModelProperty(position = 26, value = "商户名称[64]", example = "北京XXX服装贸易有限公司")
    private String busName;
    @ApiModelProperty(position = 27, value = "统一社会信用代码[64]", example = "90000000000000005")
    private String busCertCode;
    @ApiModelProperty(position = 28, value = "营业执照有效期[YYYY-MM-DD]", example = "2022-12-31")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "营业执照有效期格式有误")
    private String busCertValidity;
    @ApiModelProperty(position = 29, value = "证件是否长期有效[0-否|1-是]", example = "0")
    @NotBlank(message = "证件是否长期有效不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "证件是否长期有效参数无效")
    private String busCertLasting;
    @ApiModelProperty(position = 30, value = "营业执照照片[256]")
    private String busCertPic;
    @ApiModelProperty(position = 31, value = "营业执照照片[256]")
    private String busQualityPic;

    public GoblinStoreCertificationVo initStoreCertificationVo() {
        GoblinStoreCertificationVo vo = GoblinStoreCertificationVo.getNew();
        vo.setPersonCertType(this.getPersonCertType());
        vo.setPersonName(this.getPersonName());
        vo.setPersonCertCode(this.getPersonCertCode());
        vo.setPersonCertValidity(this.getPersonCertValidity());
        vo.setPersonCertLasting(this.getPersonCertLasting());
        vo.setPersonCertFpic(this.getPersonCertFpic());
        vo.setPersonCertBpic(this.getPersonCertBpic());
        vo.setPersonCertSpic(this.getPersonCertSpic());
        vo.setDelFlg("0");
        vo.setProvinceId(this.getProvinceId());
        vo.setProvinceName(this.getProvinceName());
        vo.setCityId(this.getCityId());
        vo.setCityName(this.getCityName());
        vo.setCountyId(this.getCountyId());
        vo.setCountyName(this.getCountyName());
        vo.setBusAddress(this.getBusAddress());
        vo.setBusName(this.getBusName());
        vo.setBusCertCode(this.getBusCertCode());
        vo.setBusCertValidity(this.getBusCertValidity());
        vo.setBusCertLasting(this.getBusCertLasting());
        vo.setBusCertPic(this.getBusCertPic());
        vo.setBusQualityPic(this.getBusQualityPic());
        return vo;
    }
}
