package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCertificationParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCompleteParam;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtCertificationService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Service
public class GoblinStoreMgtCertificationServiceImpl implements IGoblinStoreMgtCertificationService {
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;

    @Override
    public void certificationInformationProcessing(GoblinStoreMgtCertificationParam param) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();

        GoblinStoreInfoVo vo = GoblinStoreInfoVo.getNew();
        vo.setStoreId(IDGenerator.get32UUID());
        vo.setUid(uid);
        vo.setStatus("0");
        vo.setCreatedAt(now);
        vo.setCreatedBy(uid);
        vo.setCertificationVo(param.initStoreCertificationVo());

        goblinRedisUtils.setStoreInfoVo(vo);
    }

    @Override
    public void certificationCompleteProcessing(GoblinStoreMgtCompleteParam param) {
        String uid = CurrentUtil.getCurrentUid();

        GoblinStoreInfoVo storeInfoVo = goblinRedisUtils.getStoreInfoVoByUid(uid);
        param.completeStoreInfoVo(storeInfoVo);

        goblinRedisUtils.setStoreInfoVo(storeInfoVo);
    }
}
