package com.liquidnet.service.goblin.controller.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseCommonParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseParam;
import com.liquidnet.service.goblin.dto.vo.GoblinMarketSpuListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreMarketVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStorePurchaseSkuVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStorePurchasingService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 商铺活动管理
 */
@Slf4j
@RestController
@Api(tags = "活动-限时秒杀")
@RequestMapping("store/marketing")
public class GoblinStorePurchasingController {

    @Autowired
    IGoblinStorePurchasingService goblinStorePurchasingService;

    @GetMapping("purchasing/list")
    @ApiOperation("活动详情-限时秒杀列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "page", value = "页数", example = "1"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "purchaseName", value = "活动名称", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "status", value = "活动状态[-1-全部|0-等待开始|1-活动中|2-活动结束|7-停用]", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "startTime", value = "活动开始时间", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "endTime", value = "活动结束时间", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "createdAt", value = "活动创建时间", example = ""),
    })
    public ResponseDto<PageInfo<GoblinStoreMarketVo>> purchasingList(@RequestParam(value = "page", required = false) @Valid Integer page,
                                                                     @RequestParam(value = "purchaseName", required = false) String purchaseName,
                                                                     @RequestParam(value = "status", required = true) Integer status,
                                                                     @RequestParam(value = "startTime", required = false) String st,
                                                                     @RequestParam(value = "endTime", required = false) String et,
                                                                     @RequestParam(value = "createdAt", required = false) String ct) {
        return goblinStorePurchasingService.purchasingList(page, purchaseName, status, st, et, ct);
    }

    @PostMapping("purchasing/status")
    @ApiOperation("活动操作-限时秒杀")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = ""),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = ""),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "status", value = "活动状态[0-等待开始(启用)|7-停用|-1-删除]", example = ""),
    })
    public ResponseDto<Boolean> purchasingStatus(@RequestParam(value = "marketId") @Valid String marketId,
                                                 @RequestParam(value = "storeId") @Valid String storeId,
                                                 @RequestParam(value = "status") @Valid Integer status) {
        return goblinStorePurchasingService.purchasingStatus(marketId, storeId, status);
    }

    @PostMapping("purchasing")
    @ApiOperation("创建活动-限时秒杀")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> purchasingInsert(@RequestBody GoblinStorePurchaseParam goblinStorePurchaseParam) {
        return goblinStorePurchasingService.purchasingInsert(goblinStorePurchaseParam.getName(), goblinStorePurchaseParam.getStoreId(), goblinStorePurchaseParam.getStartTime(), goblinStorePurchaseParam.getEndTime(), goblinStorePurchaseParam.getIsPre(), goblinStorePurchaseParam.getPreTime());
    }

    @PutMapping("purchasing")
    @ApiOperation("修改活动-限时秒杀")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> purchasingUpdate(@RequestBody GoblinStorePurchaseParam goblinStorePurchaseParam) {
        goblinStorePurchasingService.purchasingUpdate(goblinStorePurchaseParam.getMarketId(), goblinStorePurchaseParam.getName(), goblinStorePurchaseParam.getStoreId(), goblinStorePurchaseParam.getStartTime(), goblinStorePurchaseParam.getEndTime(), goblinStorePurchaseParam.getIsPre(), goblinStorePurchaseParam.getPreTime());
        return ResponseDto.success();
    }

    @GetMapping("purchasing/details")
    @ApiOperation("活动详情-限时秒杀")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
    })
    public ResponseDto<GoblinStoreMarketVo> purchasingDetails(@RequestParam("marketId") @Valid String marketId,
                                                              @RequestParam("storeId") @Valid String storeId) {
        return goblinStorePurchasingService.purchasingDetails(marketId, storeId);
    }

    @GetMapping("purchasing/spu")
    @ApiOperation("活动详情-限时秒杀-spu列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数", example = "1"),
    })
    public ResponseDto<List<GoblinMarketSpuListVo>> purchasingSpuList(@RequestParam("marketId") @Valid String marketId,
                                                                      @RequestParam("storeId") @Valid String storeId,
                                                                      @RequestParam("page") @Valid Integer page) {
        return goblinStorePurchasingService.purchasingSpuList(marketId, storeId, page);
    }

    @GetMapping("purchasing/sku")
    @ApiOperation("活动详情-限时秒杀-sku列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "spuId", value = "spuMarketId", example = "1"),
    })
    public ResponseDto<List<GoblinStorePurchaseSkuVo>> purchasingSkuList(@RequestParam("marketId") @Valid String marketId,
                                                                         @RequestParam("storeId") @Valid String storeId,
                                                                         @RequestParam("spuMarketId") @Valid String spuId) {
        return goblinStorePurchasingService.purchasingSkuList(marketId, storeId, spuId);
    }

    @PostMapping("purchasing/sku")
    @ApiOperation("活动详情-限时秒杀-sku新增")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> purchasingSkuInsert(@RequestBody GoblinStorePurchaseCommonParam params) {
        return goblinStorePurchasingService.purchasingSkuInsert(params);
    }

    @PutMapping("purchasing/sku")
    @ApiOperation("活动详情-限时秒杀-sku修改")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> purchasingSkuUpdate(@RequestBody GoblinStorePurchaseCommonParam params) {
        return goblinStorePurchasingService.purchasingSkuUpdate(params);
    }

    @DeleteMapping("purchasing/spu")
    @ApiOperation("活动详情-限时秒杀-spu删除")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "spuId", value = "spuId", example = "1")
    })
    public ResponseDto<Boolean> purchasingSpuDel(@RequestParam("marketId") @Valid String marketId,
                                                 @RequestParam("storeId") @Valid String storeId,
                                                 @RequestParam("spuId") @Valid String spuId) {
        return goblinStorePurchasingService.purchasingSpuDel(marketId, storeId, spuId);
    }

}
