package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsActionParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsFilterParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSpecVo;
import com.liquidnet.service.goblin.service.manage.IGoblinstoreMgtGoodsService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Service
public class GoblinStoreMgtGoodsServiceImpl implements IGoblinstoreMgtGoodsService {
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;

    @Override
    public PagedResult<GoblinStoreMgtGoodsListVo> goodsList(GoblinStoreMgtGoodsFilterParam filterParam) {
        return goblinMongoUtils.getGoodsInfoVo(filterParam);
    }

    @Override
    public void goodsAdd(GoblinStoreMgtGoodsAddParam storeMgtGoodsAddParam) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();

        GoblinGoodsInfoVo vo = storeMgtGoodsAddParam.initGoodsInfoVo();
        vo.setCreatedBy(uid);
        vo.setCreatedAt(now);

        ArrayList<GoblinGoodsSpecVo> goodsSpecVoList = ObjectUtil.getGoblinGoodsSpecVoArrayList();
        List<GoblinGoodsSkuInfoVo> goodsSkuInfoVoList = ObjectUtil.getGoblinGoodsSkuInfoVoArrayList();
        storeMgtGoodsAddParam.initGoodsSkuInfoVo(vo, goodsSkuInfoVoList, goodsSpecVoList);

//        vo.setTagVoList();
//        vo.setServiceSupportVoList();
//        vo.setExtagVoList();

        goblinMongoUtils.setGoodsInfoVo(vo);
        goblinMongoUtils.setGoodsSkuInfoVos(goodsSkuInfoVoList);
    }

    @Override
    public GoblinStoreMgtGoodsInfoVo goodsInfo(String spuId) {
        GoblinStoreMgtGoodsInfoVo vo = GoblinStoreMgtGoodsInfoVo.getNew();
        GoblinGoodsInfoVo goodsInfoVo = goblinRedisUtils.getGoodsInfoVo(spuId);
        if (null != goodsInfoVo) {
            vo.setGoodsInfoVo(goodsInfoVo);
            List<String> skuIdList = goodsInfoVo.getSkuIdList();
            if (!CollectionUtils.isEmpty(skuIdList)) {
                List<GoblinGoodsSkuInfoVo> goodsSkuInfoVoList = ObjectUtil.getGoblinGoodsSkuInfoVoArrayList();
                skuIdList.forEach(skuId -> goodsSkuInfoVoList.add(goblinRedisUtils.getGoodsSkuInfoVo(skuId)));
                vo.setGoodsSkuInfoVoList(goodsSkuInfoVoList);
            }
        }
        return vo;
    }

    @Override
    public void goodsEdit(GoblinStoreMgtGoodsAddParam storeMgtGoodsAddParam) {
        // TODO: 2021/12/28 zhanggb
    }

    @Override
    public void goodsOnshelves(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam) {
        // TODO: 2021/12/28 zhanggb
    }

    @Override
    public void goodsUnshelves(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam) {
        // TODO: 2021/12/28 zhanggb
    }

    @Override
    public void goodsRemove(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam) {
        // TODO: 2021/12/28 zhanggb
    }
}
