package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 轮播图
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@ApiModel(value = "GoblinZhengzaiGoodVo", description = "正在下单商铺列表vo")
@Data
public class GoblinZhengzaiGoodVo implements Serializable {
    @ApiModelProperty(position = 10, value = "店铺ID")
    private String storeId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 12, value = "商品编码[默认为系统编码，也可手动输入商家自己的编码]")
    private String spuNo;
    @ApiModelProperty(position = 13, value = "商品名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "商品副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "销售价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 16, value = "价格区间MIN[20,2]")
    private BigDecimal priceGe;
    @ApiModelProperty(position = 17, value = "价格区间MAX[20,2]")
    private BigDecimal priceLe;
    @ApiModelProperty(position = 20, value = "封面图片地址[256]")
    private String coverPic;
    @ApiModelProperty(position = 52, value = "商品标签列表")
    private List<GoblinGoodsTagVo> tagVoList;
    @ApiModelProperty(position = 53, value = "商品服务支持列表")
    private List<GoblinServiceSupportVo> serviceSupportVoList;
    @ApiModelProperty(position = 54, value = "音乐人、艺术家、IP列表")
    private List<GoblinGoodsExtagVo> extagVoList;
    @ApiModelProperty(position = 55, value = "活动Id")
    private String marketId;

    private static final GoblinZhengzaiGoodVo obj = new GoblinZhengzaiGoodVo();

    public static GoblinZhengzaiGoodVo getNew() {
        try {
            return (GoblinZhengzaiGoodVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinZhengzaiGoodVo();
        }
    }

}
