package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.sweet.utils.WechatSignUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

@Api(tags = "公众号动作回调")
@RestController
@RequestMapping("/actionCallback")
@Slf4j
public class SweetActionCallbackController {

    @GetMapping("record")
    @ApiOperation("get")
    public void record(
            HttpServletResponse response,
            @RequestParam() String signature,
            @RequestParam() String timestamp,
            @RequestParam() String nonce,
            @RequestParam() String echostr
    ) {
        try {
            if (WechatSignUtils.checkSignature(signature, timestamp, nonce)) {
                log.info("ssssssss");
                PrintWriter out = response.getWriter();
                out.print(echostr);
                out.close();
            } else {
                log.info("这里存在非法请求");
            }
        } catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    @PostMapping("record")
    @ApiOperation("post")
    public void record() {
        log.info("111111");
    }
}
