package com.liquidnet.service.platform.controller.goblin;

import com.liquidnet.service.goblin.service.IGoblinExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;

@Api(tags = "商城-订单信息导出")
@Controller
@RequestMapping("/tools/export")
@Validated
public class GoblinExportDataController {

    @Autowired
    IGoblinExportService iGoblinExportService;

    /**
     * 导出商城订单信息
     *
     * @param beginTime
     * @param endTime
     * @return
     */
    @GetMapping("/exportMallOrder")
    @ApiOperation(value = "excel订单信息导出")
    public void exportMallOrder(HttpServletResponse response, @RequestParam("beginTime") String beginTime, @RequestParam("endTime")String endTime,
                                @RequestParam("state")String state, @RequestParam("mailType")Integer mailType) {
        iGoblinExportService.exportMallOrder(response, beginTime, endTime, state, mailType);
    }

}
