package com.liquidnet.service.sweet.vo;

import com.liquidnet.service.sweet.entity.SweetDoudouScope;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class SweetDouDouScopeVo implements Serializable, Cloneable{

    @ApiModelProperty("mobile")
    private String mobile;

    @ApiModelProperty("nickName")
    private String nickName;

    @ApiModelProperty("realName")
    private String realName;

    @ApiModelProperty("idCard")
    private String idCard;

    @ApiModelProperty("status")
    private Integer status;

    @ApiModelProperty("createdAt")
    private LocalDateTime createdAt;

    @ApiModelProperty("updatedAt")
    private LocalDateTime updatedAt;

    private static final SweetDouDouScopeVo obj = new SweetDouDouScopeVo();


    public static SweetDouDouScopeVo getNew() {
        try {
            return (SweetDouDouScopeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetDouDouScopeVo();
        }
    }

    public SweetDouDouScopeVo copy(SweetDoudouScope source) {
        if (null == source) return this;
        this.mobile = source.getMobile();
        this.nickName = source.getNickName();
        this.realName = source.getRealName();
        this.idCard = source.getIdCard();
        this.status = source.getStatus();
        this.createdAt = source.getCreatedAt();
        this.updatedAt = source.getUpdatedAt();
        return this;
    }
}
