package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dto.param.BuyNoticeParam;
import com.liquidnet.service.kylin.dto.param.BuyNoticeSearchParam;
import com.liquidnet.service.kylin.dto.vo.BuyNoticeVo;
import com.liquidnet.service.kylin.entity.KylinBuyNotice;
import com.liquidnet.service.kylin.mapper.KylinBuyNoticeMapper;
import com.liquidnet.service.kylin.service.admin.IBuyNoticeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 须知管理 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2026-01-16
 */
@Slf4j
@Service
public class KylinBuyNoticeServiceImpl extends ServiceImpl<KylinBuyNoticeMapper, KylinBuyNotice> implements IBuyNoticeService {

    @Autowired
    private KylinBuyNoticeMapper noticesMapper;

    /**
     * 创建须知
     */
    public Boolean create(BuyNoticeParam param) {
        try {
            String buyNoticeId = IDGenerator.nextSnowId();
            LocalDateTime createdAt = LocalDateTime.now();

            KylinBuyNotice kylinBuyNotice = param.getFields(buyNoticeId, createdAt);
            noticesMapper.insert(kylinBuyNotice);

            return true;
        } catch (Exception e) {
            log.error("创建须知失败", e);
            return false;
        }
    }

    /**
     * 修改须知
     */
    public Boolean update(BuyNoticeParam param) {
        try {
            String buyNoticeId = param.getBuyNoticeId();
            LocalDateTime updatedAt = LocalDateTime.now();

            KylinBuyNotice params = param.getFields(null, null);
            params.setUpdatedAt(updatedAt);

            noticesMapper.update(params, new UpdateWrapper<KylinBuyNotice>().eq("buy_notice_id", buyNoticeId));

            return true;
        } catch (Exception e) {
            log.error("修改须知失败", e);
            return false;
        }
    }

    /**
     * 须知详情
     */
    public BuyNoticeVo detail(String buyNoticeId) {
        KylinBuyNotice data = noticesMapper.selectOne(
                new UpdateWrapper<KylinBuyNotice>().eq("buy_notice_id", buyNoticeId).eq("status", 1)
        );
        
        BuyNoticeVo BuyNoticeVo = new BuyNoticeVo();
        if (data != null) {
            BeanUtils.copyProperties(data, BuyNoticeVo);
            
            // 设置须知类型名称
            if (data.getNoticeType() != null) {
                BuyNoticeVo.setNoticeTypeName(data.getNoticeType() == 1 ? "购票须知" : "观演须知");
            }
            
            // 格式化时间显示
            if (data.getCreatedAt() != null) {
                BuyNoticeVo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(data.getCreatedAt()));
            }
            if (data.getUpdatedAt() != null) {
                BuyNoticeVo.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(data.getUpdatedAt()));
            }
        } else {
            return null;
        }

        return BuyNoticeVo;
    }

    /**
     * 须知列表
     */
    public PageInfo<KylinBuyNotice> noticeList(BuyNoticeSearchParam param) {
        PageInfo<KylinBuyNotice> pageInfoTmp = null;
        try {
            PageHelper.startPage(param.getPageNum(), param.getPageSize());
            
            Map<String, Object> paramMap = BeanUtil.convertBeanToMap(param);
            log.info("原始参数对象: title={}, noticeType={}, status={}", param.getTitle(), param.getNoticeType(), param.getStatus());
            log.info("转换后的Map参数: {}", paramMap);
            
            List<KylinBuyNotice> list = noticesMapper.searchNoticesList(paramMap);
            
            // 设置须知类型名称
            if (list != null) {
                for (KylinBuyNotice item : list) {
                    if (item.getNoticeType() != null) {
                        item.setNoticeTypeName(item.getNoticeType() == 1 ? "购票须知" : "观演须知");
                    }
                }
            }
            
            pageInfoTmp = new PageInfo<>(list);
        } catch (Exception e) {
            log.error("获取须知列表失败", e);
            return new PageInfo<>();
        }
        return pageInfoTmp;
    }

    /**
     * 删除须知（逻辑删除）
     */
    public Boolean delete(List<String> buyNoticeIds) {
        try {
            LocalDateTime updatedAt = LocalDateTime.now();

            KylinBuyNotice KylinBuyNotice = new KylinBuyNotice();
            KylinBuyNotice.setUpdatedAt(updatedAt);
            KylinBuyNotice.setStatus(0);
            
            noticesMapper.update(
                    KylinBuyNotice,
                    new UpdateWrapper<KylinBuyNotice>().in("buy_notice_id", buyNoticeIds)
            );

            return true;
        } catch (Exception e) {
            log.error("删除须知失败", e);
            return false;
        }
    }
}
