package com.liquidnet.service.dragon.config;

import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.receiver.RedisPayNotifyReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

@Configuration
public class RedisStreamConfig {

    @Autowired
    private RedisPayNotifyReceiver redisPayNotifyReceiver;

    @Bean
    public Subscription subscriptionAlipayNotify0(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.ChannelRedisQueueEnum.ALIPAY_PAY_GROUP.getCode(), "alipay-pay-notify-0"),
                StreamOffset.create(DragonConstant.ChannelRedisQueueEnum.ALIPAY_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionAlipayNotify1(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.ChannelRedisQueueEnum.ALIPAY_PAY_GROUP.getCode(), "alipay-pay-notify-1"),
                StreamOffset.create(DragonConstant.ChannelRedisQueueEnum.ALIPAY_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionWepayNotify0(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.ChannelRedisQueueEnum.WECHAT_PAY_GROUP.getCode(), "wepay-pay-notify-0"),
                StreamOffset.create(DragonConstant.ChannelRedisQueueEnum.WECHAT_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionWepayNotify1(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.ChannelRedisQueueEnum.WECHAT_PAY_GROUP.getCode(), "wepay-pay-notify-1"),
                StreamOffset.create(DragonConstant.ChannelRedisQueueEnum.WECHAT_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }
}
