package com.liquidnet.service.sweet.mapper;

import com.liquidnet.service.sweet.dto.SweetWechatUsersDoTaskDto;
import com.liquidnet.service.sweet.entity.SweetWechatUsers;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * 正在现场服务号关注事件储存用户信息表 Mapper 接口
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-05
 */
public interface SweetWechatUsersMapper extends BaseMapper<SweetWechatUsers> {

    @Select({
            "select a.union_id as unionId, b.user_id as userId, b.pure_phone_number as purePhoneNumber " +
                    "from sweet_wechat_users as a" +
                    "         inner join sweet_applet_users as b on a.union_id = b.union_id" +
                    "         left join (select * from stone_score_logs where content = '关注摩登天空服务号') as ssu on ssu.uid = b.user_id " +
                    "where a.type = 2 " +
                    "and ssu.content is null " +
                    "order by a.created_at desc " +
                    "limit #{offset}"
    })
    List<SweetWechatUsersDoTaskDto> selectListDo(@Param("offset") int offset);

    @Select({
            "select count(*) " +
                    "from sweet_wechat_users as a" +
                    "         inner join sweet_applet_users as b on a.union_id = b.union_id" +
                    "         left join (select * from stone_score_logs where content = '关注摩登天空服务号') as ssu on ssu.uid = b.user_id " +
                    "where a.type = 2 " +
                    "and ssu.content is null "
    })
    int selectListDoCount();
}
