package com.liquidnet.service.kylin.controller.partner;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dao.PerformancePartnerListDao;
import com.liquidnet.service.kylin.dto.param.PerformanceCreateParam;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerListParam;
import com.liquidnet.service.kylin.dto.param.PerformanceStep1Param;
import com.liquidnet.service.kylin.dto.param.PerformanceStep2Param;
import com.liquidnet.service.kylin.service.impl.partner.KylinPerformancesPartnerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "第三方-演出")
@RestController
@RequestMapping("partner/performance")
public class PerformancePartnerController {

    @Autowired
    private KylinPerformancesPartnerServiceImpl performancesPartnerService;

    @PostMapping(value = "list")
    @ApiOperation(value = "演出列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<PerformancePartnerListDao>> getList(@RequestBody PerformancePartnerListParam performancePartnerListParam) {
        PageInfo<PerformancePartnerListDao> result = null;
        result = performancesPartnerService.getList(performancePartnerListParam);
        if (null == result) {
            return ResponseDto.failure("列表获取失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @PostMapping(value = "step1")
    @ApiOperation(value = "创建演出第一步")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> createStep1(@RequestBody PerformanceStep1Param performanceStep1Param) {
        String result = performancesPartnerService.createStep1(performanceStep1Param);
        if (result.isEmpty()) {
            return ResponseDto.failure("创建失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @PostMapping(value = "step2")
    @ApiOperation(value = "创建演出第二步")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> createStep2(@RequestBody PerformanceStep2Param performanceStep2Param) {
        boolean result = performancesPartnerService.createStep2(performanceStep2Param);
        if (!result) {
            return ResponseDto.failure("提交失败");
        } else {
            return ResponseDto.success("提交完成");
        }
    }

    @GetMapping(value = "step1")
    @ApiOperation(value = "获取演出第一步数据")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PerformanceCreateParam> createStep1(@RequestParam("performancesId") String performancesId) {
        PerformanceCreateParam result = performancesPartnerService.getStep1(performancesId);
        if (result==null) {
            return ResponseDto.failure("获取数据失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @GetMapping(value = "step2")
    @ApiOperation(value = "获取演出第二步数据")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PerformanceStep2Param> createStep2(@RequestParam("performancesId") String performancesId) {
        PerformanceStep2Param result = performancesPartnerService.getStep2(performancesId);
        if (result == null) {
            return ResponseDto.failure("获取数据失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @PostMapping(value = "online")
    @ApiOperation(value = "演出上线")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> onLinePerformance(@RequestParam("performancesId") String performancesId) {
        boolean result = performancesPartnerService.onLinePerformance(performancesId);
        if (result) {
            return ResponseDto.success("上架成功");
        } else {
            return ResponseDto.failure("上架失败");
        }
    }

    @PostMapping(value = "outline")
    @ApiOperation(value = "演出下线")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> outLinePerformance(@RequestParam("performancesId") String performancesId) {
        boolean result = performancesPartnerService.outLinePerformance(performancesId);
        if (result) {
            return ResponseDto.success("下架成功");
        } else {
            return ResponseDto.failure("下架失败");
        }
    }
}
