package com.liquidnet.service.sweet.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.feign.kylin.api.FeignKylinPerformanceClient;
//import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetRemindVo;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 公众号模版消息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-27
 */
@Service
public class SweetTemplateServiceImpl {

    @Value("${liquidnet.wechat.zhengzai.service.appid}")
    private String appid;
    @Value("${liquidnet.wechat.zhengzai.service.secret}")
    private String secret;

    @Autowired
    private RedisDataUtils redisDataUtils;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private FeignKylinPerformanceClient feignKylinPerformanceClient;

    public ResponseDto send(String templateId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_REMIND_ALL;
        Set<String> keys = redisTemplate.keys(redisKey);
        if (!CollectionUtils.isEmpty(keys)) {
            for (String rkey : keys) {
                SweetRemindVo remindInfo = (SweetRemindVo) redisUtil.get(rkey);
                // 发送模板消息接口
                WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder()
                        // 接收者openid
                        .toUser(remindInfo.getOpenId())
                        // 模板id
                        .templateId(templateId)
                        // 模板跳转链接
                        .url("http://www.baidu.com")
                        .build();
                // 添加模板数据
                templateMessage.addData(new WxMpTemplateData("first", "您好", "#FF00FF"))
                        .addData(new WxMpTemplateData("keyword1", "这是个测试", "#A9A9A9"))
                        .addData(new WxMpTemplateData("keyword2", "这又是个测试", "#FF00FF"))
                        .addData(new WxMpTemplateData("remark", "这还是个测试", "#000000"));
                String msgId = null;
                try {
                    // 发送模板消息
                    WxMpConfigStorage wxMpConfig = wxMpConfig(appid, secret);
                    WxMpService wxMpService = wxMpService(wxMpConfig);
                    msgId = wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
                } catch (WxErrorException e) {
                    e.printStackTrace();
                }
                System.out.println(msgId);
            }
        }
        return ResponseDto.success();
    }

    public ResponseDto sendMsg()
    {
        String templateId = "CNLDBZYQoDgTWudicx8WU81Jr9b6RyG9hmK4O0tpK-k";
        return send(templateId);
    }

    private WxMpConfigStorage wxMpConfig(String appId, String appSecret) {
        WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
        config.setAppId(appId);
        config.setSecret(appSecret);
        return config;
    }

    private WxMpService wxMpService(WxMpConfigStorage mpConfig) {
        WxMpService service = new WxMpServiceImpl();
        service.setWxMpConfigStorage(mpConfig);
        return service;
    }

    public ResponseDto remind(String openId, String unionId, String performancesId) {
        ResponseDto<KylinPerformanceVo> performanceVo = feignKylinPerformanceClient.detail(performancesId);
        KylinPerformanceVo performanceInfo = performanceVo.getData();
        redisDataUtils.setSweetRemind(openId, unionId, performancesId, performanceInfo);
        return ResponseDto.success();
    }
}
