package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

import java.util.ArrayList;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 分页拉取指定账户持有碎片列表
 * @class: Xuper001GetStokenReqDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper011ListSdsByAddrRespDto {
    public long requestId;
    public int errNo;
    public String errMsg;
    public ArrayList<ShardMeta> list;
    public int totalCnt;

    @Data
    public static class ShardMeta {
        public long assetId;
        public long shardId;
        public String ownerAddr;
        public long uid;
        public long price;
        public int status;
        public String txId;
        public ShardAssetInfo assetInfo;
        public long ctime;
    }

    @Data
    public static class ShardAssetInfo {
        public String title;
        public int assetCate;
        public Thumb[] thumb;
        public String shortDesc;
        public String createAddr;
        public long groupId;
    }

    @Data
    public static class Thumb {
        private Urls urls;
        private String width;
        private String height;
    }

    @Data
    public static class Urls {
        private String icon;
        private String url1;
        private String url2;
        private String url3;
    }

    private static final Xuper011ListSdsByAddrRespDto obj = new Xuper011ListSdsByAddrRespDto();
    public static Xuper011ListSdsByAddrRespDto getNew() {
        try {
            return (Xuper011ListSdsByAddrRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper011ListSdsByAddrRespDto();
        }
    }
}
