package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyQueryNftTradeListRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/8 16:27
 */
@ApiModel(value = "GalaxyQueryNftTradeListRespDto", description = "单个NFT交易信息查询")
@Data
public class GalaxyQueryNftTradeListRespDto implements Serializable,Cloneable {
     /**
      * * 交易信息总数
     */
    private Long total;
    /**
     * 交易信息列表
     */
    private List<TransInfoDto> transList;

    @Data
    public static class TransInfoDto{
        /**
         * 持有者地址
         */
        @ApiModelProperty(position = 1, required = true, value = "持有者地址")
        private String fromAddr;
        /**
         * 接收方地址
         */
        @ApiModelProperty(position = 1, required = true, value = "接收方地址")
        private String toAddr;
        /**
         * 成交积分
         */
        @ApiModelProperty(position = 1, required = true, value = "成交积分")
        private Long dealCount;
        /**
         * 链上交易hash
         */
        @ApiModelProperty(position = 1, required = true, value = "链上交易hash")
        private String txHash;
        /**
         * 积分接收地址
         */
        @ApiModelProperty(position = 1, required = true, value = "积分接收地址")
        private String pointReceiverAddr;
        /**
         * 链上成交时间
         */
        @ApiModelProperty(position = 1, required = true, value = "链上成交时间")
        private Long dealTimestamp;

        /**
         * 链上成交时间
         */
        @ApiModelProperty(position = 1, required = true, value = "链上成交时间(北京时间)")
        private String dealTimestampStr;

        /**
         * 交易类别， 1:发行 2:购买 3:转移 4:设置价格 5:设置状态
         */
        @ApiModelProperty(position = 1, required = true, value = "交易类别， 1:发行 2:购买 3:转移 4:设置价格 5:设置状态")
        private Integer txType;

        private static final TransInfoDto obj = new TransInfoDto();

        public static TransInfoDto getNew() {
            try {
                return (TransInfoDto) obj.clone();
            } catch (CloneNotSupportedException e) {
                return new TransInfoDto();
            }
        }
    }

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQueryNftTradeListRespDto obj = new GalaxyQueryNftTradeListRespDto();

    public static GalaxyQueryNftTradeListRespDto getNew() {
        try {
            return (GalaxyQueryNftTradeListRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQueryNftTradeListRespDto();
        }
    }
}