package com.liquidnet.service.goblin.service.impl.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMoneyService;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreOrderService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;

@Service
public class GoblinStoreOrderServiceImpl implements IGoblinStoreOrderService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;

    @Override
    public ResponseDto<PageInfo<GoblinStoreOrderListVo>> orderList(Integer page, String orderCode, Integer type, String cst, String cet, String expressContacts, String phone, Integer status) {
        List<GoblinStoreOrderListVo> listVos = ObjectUtil.getGoblinStoreOrderListVoArrayList();
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        HashMap<String, Object> map = mongoUtils.storeOrderList(storeInfoVo.getStoreId(), page, orderCode, cst, cet, expressContacts, phone, status);
        long total = (long) map.get("total");
        List<GoblinStoreOrderVo> voList = (List<GoblinStoreOrderVo>) map.get("data");
        for (GoblinStoreOrderVo item : voList) {
            GoblinStoreOrderListVo vo = GoblinStoreOrderListVo.getNew();
            vo.setCreatedAt(item.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            vo.setExpressAddressDetail(item.getOrderAttrVo().getExpressAddressDetail());
            vo.setExpressContacts(item.getOrderAttrVo().getExpressContacts());
            vo.setExpressPhone(item.getOrderAttrVo().getExpressPhone());
            vo.setOrderCode(item.getOrderCode());
            vo.setExpressAddress(item.getOrderAttrVo().getExpressAddress());
            vo.setOrderId(item.getOrderId());
            vo.setPayType(item.getPayType());
            vo.setPriceActual(item.getPriceActual());
            vo.setStatus(item.getStatus());
            for (String skuId : item.getOrderSkuVoIds()) {
                GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(skuId);
            }
        }
        PageInfo<GoblinStoreOrderListVo> pageInfo = new PageInfo(listVos);
        pageInfo.setTotal(total);
        return ResponseDto.success(pageInfo);
    }
}
