package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsSkuArAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsSkuArFilterParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsSkuArListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtGoodsSkuExtraService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@ApiSupport(order = 149005)
@Api(tags = "商品管理:单品拓展信息")
@Slf4j
@Validated
@RestController
@RequestMapping("store/mgt/sku_extra")
public class GoblinStoreMgtGoodsSkuExtraController {
    @Autowired
    IGoblinStoreMgtGoodsSkuExtraService goblinStoreMgtGoodsSkuExtraService;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "藏品AR:列表")
    @PostMapping("ar_list")
    public ResponseDto<PagedResult<GoblinStoreMgtGoodsSkuArListVo>> arList(@Valid @RequestBody GoblinStoreMgtGoodsSkuArFilterParam mgtGoodsSkuArFilterParam) {
        String currentUid = CurrentUtil.getCurrentUid();
        if (!goblinRedisUtils.hasStoreId(currentUid, mgtGoodsSkuArFilterParam.getStoreId())) {
            log.warn("商品管理:藏品AR:列表:无权操作该店铺，请核实[UID={},GoblinStoreMgtGoodsSkuArFilterParam={}]", currentUid, JsonUtils.toJson(mgtGoodsSkuArFilterParam));
            return ResponseDto.success();
        }
        if (log.isDebugEnabled()) {
            log.debug("商品管理:藏品AR:列表[GoblinStoreMgtGoodsSkuArFilterParam={}]", JsonUtils.toJson(mgtGoodsSkuArFilterParam));
        }
        return ResponseDto.success(goblinStoreMgtGoodsSkuExtraService.skuArList(mgtGoodsSkuArFilterParam));
    }

//    @ApiOperationSupport(order = 2)
//    @ApiOperation(value = "藏品AR:管理")
//    @PostMapping("ar_action")
//    public ResponseDto<Object> action(@Valid @RequestBody GoblinStoreMgtGoodsSkuArActionParam mgtGoodsSkuArActionParam) {
//        String currentUid = CurrentUtil.getCurrentUid(), storeId = mgtGoodsSkuArActionParam.getStoreId();
//        if (!goblinRedisUtils.hasStoreId(currentUid, storeId)) {
//            return ResponseDto.failure(ErrorMapping.get("149002"));
//        }
//        List<String> skuIdList = mgtGoodsSkuArActionParam.getSkuIdList();
//        if (CollectionUtils.isEmpty(skuIdList)) {
//            return ResponseDto.failure(ErrorMapping.get("149021"));
//        }
//        if (log.isDebugEnabled()) {
//            log.debug("商品管理:藏品AR:管理[UID={},GoblinStoreMgtGoodsActionParam={}]", currentUid, JsonUtils.toJson(mgtGoodsSkuArActionParam));
//        }
//        boolean resultFlg;
//        switch (mgtGoodsSkuArActionParam.getAction()) {
//            case "REMOVE":
//                for (String skuId : skuIdList) {
//                    GoblinGoodsSkuInfoVo mgtGoodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(skuId);
//                    if (null == mgtGoodsSkuInfoVo || !mgtGoodsSkuInfoVo.getDelFlg().equals("0")) {
//                        log.warn("商品管理:藏品AR:管理:藏品不存在或已删除[UID={},skuId={}]", currentUid, skuId);
//                        return ResponseDto.failure(ErrorCode.HTTP_PARAM_ERROR.getCode(), "藏品AR不存在或已删除");
//                    }
//                    if (mgtGoodsSkuInfoVo.getSkuType() != 1) {
//                        log.warn("商品管理:藏品AR:管理:非数字藏品不支持此操作[UID={},skuId={}]", currentUid, skuId);
//                        return ResponseDto.failure(ErrorCode.HTTP_PARAM_ERROR.getCode(), "无效操作，非数字藏品");
//                    }
//                    if (!mgtGoodsSkuInfoVo.getStoreId().equals(storeId)) {
//                        log.warn("商品管理:藏品AR:管理:非本店铺藏品，无权操作[UID={},skuId={}]", currentUid, skuId);
//                        return ResponseDto.failure(ErrorCode.HTTP_PARAM_ERROR.getCode(), "非本店铺藏品，无权操作");
//                    }
//                }
//                resultFlg = goblinStoreMgtGoodsSkuExtraService.skuArDel(currentUid, skuIdList);
//                break;
//            default:
//                log.warn("商品管理:藏品AR:管理:Invalid operation[UID={},GoblinStoreMgtGoodsSkuArActionParam={}]", currentUid, JsonUtils.toJson(mgtGoodsSkuArActionParam));
//                return ResponseDto.failure(ErrorMapping.get("149001"));
//        }
//        return resultFlg ? ResponseDto.success() : ResponseDto.failure();
//    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "藏品AR:添加")
    @PostMapping("ar_add")
    public ResponseDto<Object> arAdd(@Valid @RequestBody GoblinStoreMgtGoodsSkuArAddParam mgtGoodsSkuArAddParam) {
        String currentUid = CurrentUtil.getCurrentUid(), storeId = mgtGoodsSkuArAddParam.getStoreId();
        if (!goblinRedisUtils.hasStoreId(currentUid, storeId)) {
            return ResponseDto.failure(ErrorMapping.get("149002"));
        }
        GoblinGoodsSkuInfoVo mgtGoodsSkuInfoVo;
        if (null == (mgtGoodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(mgtGoodsSkuArAddParam.getSkuId()))
                || !mgtGoodsSkuInfoVo.getStoreId().equals(storeId)
                || !mgtGoodsSkuInfoVo.getDelFlg().equals("0")
        ) {
            return ResponseDto.failure(ErrorMapping.get("149011"));
        }
        if (StringUtils.isNotEmpty(mgtGoodsSkuInfoVo.getArUrlIos())) {
            return ResponseDto.failure(ErrorMapping.get("149019"));
        }
        if (log.isDebugEnabled()) {
            log.debug("商品管理:藏品AR:添加[GoblinStoreMgtGoodsSkuArAddParam={}]", JsonUtils.toJson(mgtGoodsSkuArAddParam));
        }
        boolean resultFlg = goblinStoreMgtGoodsSkuExtraService.skuArAddEdit(currentUid, mgtGoodsSkuArAddParam, false);
        return resultFlg ? ResponseDto.success() : ResponseDto.failure(ErrorMapping.get("149003"));
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "藏品AR:编辑")
    @PostMapping("ar_edit")
    public ResponseDto<Object> arEdit(@Valid @RequestBody GoblinStoreMgtGoodsSkuArAddParam mgtGoodsSkuArEditParam) {
        String currentUid = CurrentUtil.getCurrentUid(), storeId = mgtGoodsSkuArEditParam.getStoreId();
        if (!goblinRedisUtils.hasStoreId(currentUid, storeId)) {
            return ResponseDto.failure(ErrorMapping.get("149002"));
        }
        GoblinGoodsSkuInfoVo mgtGoodsSkuInfoVo;
        if (null == (mgtGoodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(mgtGoodsSkuArEditParam.getSkuId()))
                || !mgtGoodsSkuInfoVo.getStoreId().equals(storeId)
                || !mgtGoodsSkuInfoVo.getDelFlg().equals("0")
        ) {
            return ResponseDto.failure(ErrorMapping.get("149011"));
        }
        if (StringUtils.isEmpty(mgtGoodsSkuInfoVo.getArUrlIos())) {
            return ResponseDto.failure(ErrorMapping.get("149020"));
        }
        if (log.isDebugEnabled()) {
            log.debug("商品管理:藏品AR:编辑[GoblinStoreMgtGoodsAddParam={}]", JsonUtils.toJson(mgtGoodsSkuArEditParam));
        }
        boolean resultFlg = goblinStoreMgtGoodsSkuExtraService.skuArAddEdit(currentUid, mgtGoodsSkuArEditParam, true);
        return resultFlg ? ResponseDto.success() : ResponseDto.failure(ErrorMapping.get("149003"));
    }
}
