package com.liquidnet.service.order.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.order.service.impl.OrderApplePayServiceImpl;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

/**
 * <p>
 * 苹果支付相关 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-07
 */
@Api(tags = "苹果-支付相关")
@RestController
@Validated
@RequestMapping("/apple")
public class OrderApplePayController {

    @Autowired
    private OrderApplePayServiceImpl applePayService;

    @PostMapping("pay")
    @ApiOperation("苹果支付成功通知")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单ID", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "订单类型 NFT", example = "NFT"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "receiptData", value = "receipt-data", example = "M0WWAoL3nK5I1xF3OX2n9aHlQptG4NbuHbkYmD7cBsLT"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "transactionId", value = "transactionId", example = "2000000027803904"),
    })
    public ResponseDto pay(
            @RequestParam("orderId") @NotBlank(message = "订单ID不能为空") String orderId,
            @RequestParam("type") @NotBlank(message = "订单类型不能为空") @Pattern(regexp = "\\b(NFT)\\b", message = "订单类型无效") String type,
            @RequestParam("receiptData") @NotBlank(message = "receiptData不能为空") String receiptData,
            @RequestParam("transactionId") @NotBlank(message = "transactionId不能为空") String transactionId
    ) {
        boolean isPay = applePayService.pay(orderId, type, receiptData, transactionId);
        if (isPay) {
            return ResponseDto.success("支付成功");
        } else {
            return ResponseDto.failure("未获取到支付状态");
        }
    }

}
