package com.liquidnet.service.goblin.dto.manage;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@ApiModel(value = "GoblinGoodsAnticipateParam", description = "预约")
@Data
public class GoblinGoodsAnticipateAddParam {

    /**
     * 预约名称
     */
//    @ApiModelProperty(value = "预约名称")
//    @NotBlank(message = "预约名称")
//    private String name;

    /**
     * 预约规则
     */
    @ApiModelProperty(value = "预约规则")
    @NotBlank(message = "预约规则")
    private String rule;

    @ApiModelProperty(value = "预约类型（1：预约提醒，2：预约获得购买资格）")
    @NotBlank(message = "预约类型")
    private int type;

    @ApiModelProperty(value = "预约人数（达到一定人数可以预约）")
    @NotBlank(message="预约人数")
    private Integer people;

    @ApiModelProperty("sku信息")
    @NotBlank
    private List<GoblinGoodsAnticipateValueAddParam> list;


}
