package com.liquidnet.service.platform.controller.goblin.activity;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.param.GoblinNftExActivityParam;
import com.liquidnet.service.goblin.service.IGoblinNftExActivityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * @Author: wll
 * @Date:Create：in 2022/4/19 2:55 下午
 */


@Api(tags = "nft兑换活动")
@Slf4j
@Validated
@RestController
@RequestMapping("activity")
public class GoblinNftExActivityController {

    @Autowired
    IGoblinNftExActivityService iGoblinNftExActivityService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加nft兑换活动")
    @PostMapping("add")
    public ResponseDto<Object> add(@Valid @RequestBody GoblinNftExActivityParam goblinNftExActivityParam){
        return ResponseDto.success(iGoblinNftExActivityService.add(goblinNftExActivityParam));
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "活动列表")
    @PostMapping("pageList")
    public ResponseDto<Object> pageList(@Valid @RequestBody GoblinNftExActivityParam goblinNftExActivityParam){
        return ResponseDto.success(iGoblinNftExActivityService.pageList(goblinNftExActivityParam));
    }

}
