package com.liquidnet.service.stone.controller;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.stone.service.IStoneScoreOrderService;
import com.liquidnet.service.stone.vo.StoneOrderListVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api(tags = "积分-订单相关")
@RestController
@RequestMapping("order")
@Validated
public class StoneOrderController {

    @Autowired
    IStoneScoreOrderService stoneScoreOrderService;

    @PostMapping("pre")
    @ApiOperation("纯积分商品下单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> order(@RequestParam("itemId") @Valid String itemId,
                                     @RequestParam("number") @Valid Integer number) {
        return stoneScoreOrderService.order(itemId,number);
    }

    @GetMapping("list")
    @ApiOperation("积分订单列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<List<StoneOrderListVo>>> orderList(@RequestParam("page") @Valid Integer page) {
        return ResponseDto.success(stoneScoreOrderService.orderList(page));
    }
}
