/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.handler;

import com.taobao.api.internal.toplink.embedded.websocket.WebSocket;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.frame.Frame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.FrameParser;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandler;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandlerChain;
import com.taobao.api.internal.toplink.embedded.websocket.handshake.Handshake;
import java.nio.ByteBuffer;

public class WebSocketStreamHandler
implements StreamHandler {
    private final Handshake handshake;
    private final FrameParser frameParser;

    public WebSocketStreamHandler(Handshake handshake, FrameParser frameParser) {
        this.handshake = handshake;
        this.frameParser = frameParser;
    }

    public void nextUpstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame, StreamHandlerChain chain) throws WebSocketException {
        chain.nextUpstreamHandler(ws, frame.toByteBuffer(), null);
    }

    public void nextDownstreamHandler(WebSocket ws, ByteBuffer buffer, Frame nullFrame, StreamHandlerChain chain) throws WebSocketException {
        while (buffer.hasRemaining()) {
            Frame frame = this.frameParser.parse(buffer);
            if (frame == null) continue;
            chain.nextDownstreamHandler(ws, buffer, frame);
        }
    }

    public void nextHandshakeUpstreamHandler(WebSocket ws, ByteBuffer buffer, StreamHandlerChain chain) throws WebSocketException {
        ByteBuffer request = this.handshake.createHandshakeRequest();
        chain.nextHandshakeUpstreamHandler(ws, request);
    }

    public void nextHandshakeDownstreamHandler(WebSocket ws, ByteBuffer buffer, StreamHandlerChain chain) throws WebSocketException {
        if (this.handshake.handshakeResponse(buffer)) {
            chain.nextHandshakeDownstreamHandler(ws, buffer);
        }
    }
}

