package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.service.kylin.dao.OrderTicketsListDao;
import com.liquidnet.service.kylin.dto.param.admin.OrderListReq;
import com.liquidnet.service.kylin.dto.vo.admin.OrderDetailsAdminVo;
import com.liquidnet.service.kylin.service.admin.IKylinOrderTicketsAdminService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 订单Controller
 *
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/order")
public class KylinOrderTicketsController extends BaseController
{
    private String prefix = "zhengzai/kylin/order";

    @Autowired
    private IKylinOrderTicketsAdminService iKylinOrderTicketsAdminService;

    @RequiresPermissions("kylin:order:orderlist:view")
    @GetMapping("/orderList")
    public String tickets()
    {
        return prefix + "/orderList/orderList";
    }

    /**
     * 查询订单列表
     */
    @RequiresPermissions("kylin:order:orderlist:list")
    @PostMapping("/orderList/list")
    @ResponseBody
    public TableDataInfo list(OrderListReq orderListReq)
    {
        startPage();
        List<OrderTicketsListDao> list = iKylinOrderTicketsAdminService.orderList(orderListReq);
        return getDataTable(list);
    }

    /**
     * 订单详情
     */
    @RequiresPermissions("kylin:order:orderlist:detail")
    @GetMapping("/orderList/detail/{orderId}")
    public String addPerformance(@PathVariable("orderId") String orderId, ModelMap mmap) {
        OrderDetailsAdminVo orderDetailsVo = iKylinOrderTicketsAdminService.orderDetails(orderId);
        mmap.put("orderDetailsVo", orderDetailsVo);
        return prefix + "/orderList/details";
    }

}
