package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinDigitalArtworkVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5920952408993245963L;
    private String artworkId;
    private String skuId;
    private String uid;
    private String orderId;
    private Integer editionSn;
    private String nftId;
    private String releaseTxhash;
    private String releaseAt;
    private String tradingTxhash;
    private String tradingAt;
    private Integer source;
    private Integer state;
    private String delFlg;
    private LocalDateTime openingAt;
    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;
    private LocalDateTime deletedAt;

    /* ---------------------- 冗余SPU信息 ---------------------- */
    private String author;
    private String publisher;

    private static final GoblinDigitalArtworkVo obj = new GoblinDigitalArtworkVo();

    public static GoblinDigitalArtworkVo getNew() {
        try {
            return (GoblinDigitalArtworkVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinDigitalArtworkVo();
        }
    }
}
