package com.liquidnet.client.admin.zhengzai.adam.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberAdminService;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.AdamMemberParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.mapper.AdamMemberMapper;
import com.liquidnet.service.base.ResponseDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class AdamMemberServiceAdminImpl extends ServiceImpl<AdamMemberMapper, AdamMember> implements IAdamMemberAdminService {
    @Autowired
    AdamMemberMapper adamMemberMapper;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public AdamMemberVo add(AdamMemberParam param) {
        AdamMember adamMember = new AdamMember();
        BeanUtils.copyProperties(param, adamMember);

        List<AdamMember> existList = adamMemberMapper.selectList(Wrappers.lambdaQuery());

        adamMember.setMemberId(CollectionUtils.isEmpty(existList) ? "1" : IDGenerator.nextSnowId());
        adamMember.setType(1);
        adamMember.setStartNo(10000);
        adamMember.setCreatedAt(LocalDateTime.now());
        adamMember.setUpdatedAt(LocalDateTime.now());

        adamMemberMapper.insert(adamMember);

        AdamMemberVo vo = AdamMemberVo.getNew().copy(adamMember);

        mongoTemplate.insert(vo, AdamMemberVo.class.getSimpleName());

        redisUtil.set(AdamRedisConst.INFO_MEMBER_CATEGORY.concat(vo.getMemberId()), vo);

        return vo;
    }
}
