package com.liquidnet.client.admin.zhengzai.smile.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-22
 */
@Data
public class SmilePriceParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 演出id
     */
    @ApiModelProperty(value = "演出id")
    @NotBlank(message = "演出id不能为空")
    private String performancesId;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户uid")
    @NotBlank(message = "用户id不能为空")
    private String uid;

    /**
     * 打款金额
     */
    @ApiModelProperty(value = "打款金额不能为空")
    private BigDecimal price;

    @ApiModelProperty(value = "打款标识0打款，1未打款")
    @NotBlank(message = "打款标识不能为空")
    private Integer status;

}
