package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.SweetWechatLoginServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "小程序-公众号登陆相关")
@RestController
@RequestMapping("/wechatLogin")
@Slf4j
public class SweetWechatLoginController {

    @Autowired
    private SweetWechatLoginServiceImpl sweetLoginService;

    @GetMapping("userInfo")
    @ApiOperation("code获取用户信息")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "code", value = "微信code", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "encryptedData", value = "encryptedData", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "iv", value = "iv", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1草莓 2五百里 3mdsk 4正在"),
    })
    public ResponseDto userInfo(
            @RequestParam() String code,
            @RequestParam() String encryptedData,
            @RequestParam() String iv,
            @RequestParam(defaultValue = "1") Integer type
    ) {
        return sweetLoginService.userInfo(code, encryptedData, iv, type);
    }

    @ApiOperation(value = "微信小程序登录凭证校验 获取openid", notes = "这里仅用于获取OPENID使用")
    @GetMapping(value = {"maOpenId"})
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "jsCode", value = "微信jsCode", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1草莓 2五百里 3mdsk 4正在", required = true)
    })
    public ResponseDto<String> wxaCode2Session(@RequestParam String jsCode, @RequestParam Integer type) {
        return sweetLoginService.wxaCode2Session(jsCode, type);
    }

    @ApiOperation(value = "微信公众号登录 获取openid", notes = "这里仅用于获取OPENID使用")
    @GetMapping(value = {"mpOpenId"})
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "code", value = "微信code", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1草莓 2五百里 3mdsk 4正在", required = true)
    })
    public ResponseDto<String> wxOauth2AccessToken(@RequestParam String code, @RequestParam Integer type) {
        return sweetLoginService.wxOauth2AccessToken(code, type);
    }

}
